/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.baselayer.filesystemImpl.LocalFilesystemHandler;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;

public class BaseLayerStream {
    private static final Log log = LogFactory.getLog(BaseLayerStream.class);
    public static final int URL_CONNECTION_LENGTH_UNKNOWN = -1;
    public static final long STREAM_LENGTH_IMPLICITE = Long.MIN_VALUE;
    public static final long NO_LIMIT = -9223372036854775807L;
    public static final int END_OF_STREAM = -1;
    protected InputStream inputStream;
    protected long length;
    protected long limit = -9223372036854775807L;
    protected boolean buffered;
    protected static int defautBufferSize = 4096;
    private int bufferSize = BaseLayerStream.getDefaultBufferSize();

    public static void setDefaultBufferSize(int size) {
        defautBufferSize = size;
    }

    public static int getDefaultBufferSize() {
        return defautBufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public BaseLayerStream(InputStream istream) {
        this(istream, Long.MIN_VALUE);
    }

    public BaseLayerStream(InputStream istream, long length) {
        this.inputStream = istream;
        this.length = length;
        this.adjustBuffered();
    }

    protected void adjustBuffered() {
        if (this.inputStream instanceof BufferedInputStream) {
            this.setBuffered(true);
        }
    }

    public InputStream getStream() {
        return this.inputStream;
    }

    public InputStream getBufferedStream() {
        if (this.isBuffered()) {
            return this.getStream();
        }
        return new BufferedInputStream(this.getStream());
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean isBuffered) {
        this.buffered = isBuffered;
    }

    public long getLength() {
        return this.length;
    }

    public boolean hasImpliciteLength() {
        return this.length == Long.MIN_VALUE;
    }

    public void setLimit(long maximumLength) {
        this.limit = maximumLength;
    }

    public boolean needsLimitTreatment() {
        return this.limit != -9223372036854775807L;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(BasicStorageHints hints) throws ValueNotValidException {
        if (hints == null) {
            return;
        }
        this.handleStartOffset(hints);
        String maxStreamLength = hints.getHintValue("read-at-most-bytes");
        if (maxStreamLength != null && !hints.isConsumedHint("read-at-most-bytes")) {
            long limit = BaseLayerUtils.convertHintToLong(maxStreamLength, "read-at-most-bytes");
            if (limit < 0L) {
                throw new ValueNotValidException("read-at-most-bytes may not be negative!", Long.toString(limit), "read-at-most-bytes");
            }
            this.setLimit(limit);
            hints.markHint("read-at-most-bytes", true);
        }
    }

    public void handleStartOffset(BasicStorageHints hints) throws ValueNotValidException {
        if (hints == null) {
            return;
        }
        String startOffset = hints.getHintValue("start-reading-at-byte-position");
        if (startOffset != null && !hints.isConsumedHint("start-reading-at-byte-position")) {
            long offset;
            log.debug((Object)("Skipping " + startOffset + " bytes because hint '" + "start-reading-at-byte-position" + "' has been set."));
            try {
                offset = Long.parseLong(startOffset);
            }
            catch (NumberFormatException nfe) {
                log.debug((Object)"Not a valid long value for start offset.", (Throwable)nfe);
                throw new ValueNotValidException("Expected a positive long value.", startOffset, "start-reading-at-byte-position");
            }
            try {
                this.getStream().skip(offset);
            }
            catch (IOException ioe) {
                log.debug((Object)("Could not skip " + offset + " bytes."), (Throwable)ioe);
                throw new ValueNotValidException("Could not skip " + offset + " bytes as requested in hint '", String.valueOf(offset), "start-reading-at-byte-position'");
            }
            hints.markHint("start-reading-at-byte-position", true);
        }
    }

    public long writeToStreamRespectingLimit(OutputStream out) throws BaseLayerException {
        long count;
        try {
            int numRead;
            InputStream is = this.getBufferedStream();
            byte[] buffer = new byte[this.getBufferSize()];
            if (this.hasImpliciteLength()) {
                if (this.needsLimitTreatment()) {
                    log.debug((Object)"Writing stream with implicite length, but explicite limit on length");
                    while (true) {
                        long numToRead;
                        if ((numToRead = Math.min((long)buffer.length, this.limit - count)) <= 0L) {
                            log.debug((Object)"Limit reached - done copying.");
                            return count;
                        }
                        assert (numToRead <= Integer.MAX_VALUE && numToRead > 0L) : "Something's wrong here: " + numToRead + " is much to big or less than zero.";
                        int numRead2 = is.read(buffer, 0, (int)numToRead);
                        if (numRead2 == -1) {
                            return count;
                        }
                        out.write(buffer, 0, numRead2);
                        count += (long)numRead2;
                    }
                }
                log.debug((Object)"Writing stream with implicite length and limit on length");
                while (true) {
                    int numRead3;
                    if ((numRead3 = is.read(buffer)) == -1) {
                        log.debug((Object)"Reached end of stream - done copying.");
                        return count;
                    }
                    out.write(buffer, 0, numRead3);
                    count += (long)numRead3;
                }
            }
            long realLimit = this.needsLimitTreatment() ? Math.min(this.length, this.limit) : this.length;
            log.debug((Object)("Writing stream with explicite length of " + realLimit + " bytes"));
            for (count = 0L; count < realLimit; count += (long)numRead) {
                int maxBytes = (int)Math.min((long)buffer.length, realLimit - count);
                numRead = is.read(buffer, 0, maxBytes);
                if (numRead == -1) {
                    log.debug((Object)("Premature end of stream after reading " + count + " bytes; length (" + this.length + ") must have been incorrect."));
                    return count;
                }
                out.write(buffer, 0, numRead);
            }
            log.info((Object)"Wrote all bytes according to length - done copying.");
            this.length -= count;
            assert (count <= realLimit);
            log.debug((Object)("Wrote " + count + " bytes to output stream."));
            return count;
        }
        catch (EOFException eof) {
            log.debug((Object)("Stream did not signal some end of stream in a more elagant way, so stopping reading after " + count + " bytes with EOFException."), (Throwable)eof);
            return count;
        }
        catch (IOException ioe) {
            throw new BaseLayerException("I/O Error while reading input stream.", ioe);
        }
    }

    public void dispose() throws BaseLayerException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            this.length = 0L;
        }
        catch (IOException ioe) {
            log.warn((Object)"Could not close input stream.");
            log.debug((Object)ioe);
        }
    }

    public BaseLayerStream toFixedLengthStream() throws BaseLayerException {
        if (this.hasImpliciteLength()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                File tmpFile = File.createTempFile("tmp", "filestorage");
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));
                ((OutputStream)os).write(baos.toByteArray());
                baos.close();
                baos = null;
                log.debug((Object)"Wrote content from memory to file. Continue with remaining stuff.");
                this.writeToStreamRespectingLimit(os);
                this.dispose();
                ((OutputStream)os).close();
                LocalFilesystemHandler tmpStore = LocalFilesystemHandler.getManagerFor(tmpFile.getParentFile().getAbsolutePath());
                BasicStorageHints newHints = new BasicStorageHints();
                newHints.addHint("delete-after-transfer", BasicStorageHints.HINT_VALUE_TRUE);
                return tmpStore.getBinaryContent(new RawContentLocation(tmpFile.getName(), tmpStore.getDataProvider()), newHints);
            }
            catch (IOException ioe) {
                throw new BaseLayerException("Out of memory while reading stream into memory or to disk.", ioe);
            }
        }
        return this;
    }
}

