/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.rdbmsImpl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;

public class SubstringStream
extends BaseLayerStream {
    public static final int SUGGESTED_MINIMAL_BUFFER_SIZE = 0x100000;

    public SubstringStream(Connection c, String contentID, BasicStorageHints hints) throws BaseLayerException {
        super(null);
        try {
            int bufferSize;
            if (hints != null && hints.hasHint("preferred-buffer-size")) {
                bufferSize = BaseLayerUtils.convertHintToInteger(hints.getHintValue("preferred-buffer-size"), "preferred-buffer-size");
                if (bufferSize > 0x100000) {
                    hints.markHint("preferred-buffer-size", true);
                } else {
                    bufferSize = 0x100000;
                }
            } else {
                bufferSize = Math.max(BaseLayerStream.getDefaultBufferSize(), 0x100000);
            }
            contentID = contentID.replaceAll("'", "''");
            SubstringInputStream stream = new SubstringInputStream(c, contentID, bufferSize);
            this.inputStream = stream;
            this.length = stream.getLength();
            this.setBuffered(true);
            this.handleStartOffset(hints);
        }
        catch (IOException ioe) {
            throw new BaseLayerException("Could not open stream to content '" + contentID + "' of database. Reason: " + ioe.getMessage());
        }
    }

    protected static class SubstringInputStream
    extends InputStream {
        private static final Log log = LogFactory.getLog(SubstringInputStream.class);
        private byte[] buffer = null;
        private long blobPos = 1L;
        private final Connection connection;
        private int bufferSize;
        private final String contentID;
        private int bufferPos = 0;
        private long mark = -1L;
        private final long blobLength;
        private boolean closed = false;

        SubstringInputStream(Connection c, String contentID, int bufferSize) throws IOException {
            this.connection = c;
            try {
                this.connection.setTransactionIsolation(2);
                this.connection.setAutoCommit(false);
            }
            catch (SQLException sqle) {
                log.warn((Object)"Could net set transaction to READ COMMITED and AUTOCOMMIT to false.");
                log.debug((Object)sqle);
            }
            this.contentID = contentID;
            this.bufferSize = bufferSize;
            this.blobLength = Long.MIN_VALUE;
        }

        public long getLength() {
            return this.blobLength;
        }

        private int fillBuffer(boolean logUnreadBytes) throws IOException {
            log.debug((Object)"(Re)-filling buffer...");
            if (this.blobPos == -1L) {
                return -1;
            }
            if (logUnreadBytes && log.isWarnEnabled() && this.buffer != null && this.available() > 0) {
                log.warn((Object)("Buffer contains " + this.available() + " unread bytes, that will be overwritten."));
            }
            try {
                assert (this.blobPos > 0L) : "Illegal BLOB position - " + this.blobPos + " is negative or zero - which would have a unwnated meaning according to ANSI SQL.";
                assert (this.bufferSize > 0) : "Illegal number of bytes requested - " + this.bufferSize + " is not positive";
                String nonPreparedStatement = "SELECT SUBSTRING(Raw_Content FROM " + this.blobPos + " FOR " + this.bufferSize + ") FROM " + "Raw_Object_Content" + " WHERE " + "Raw_Object_ID" + " = '" + this.contentID + "'";
                ResultSet rs = this.connection.createStatement().executeQuery(nonPreparedStatement);
                if (rs.next()) {
                    this.buffer = rs.getBytes(1);
                    rs.close();
                    int bytesRead = this.buffer.length;
                    this.blobPos = bytesRead < this.bufferSize ? -1L : (this.blobPos += (long)bytesRead);
                    this.bufferPos = 0;
                    return this.buffer.length;
                }
                log.warn((Object)(this.contentID + " does not exist."));
                throw new FileNotFoundException("Raw content does not exist: " + this.contentID);
            }
            catch (SQLException e) {
                log.error((Object)e);
                throw new IOException(e.getMessage());
            }
        }

        public int available() {
            if (this.buffer == null) {
                return 0;
            }
            return this.buffer.length - this.bufferPos;
        }

        public boolean markSupported() {
            return true;
        }

        private int prepareBufferForRead() throws IOException {
            if (this.closed) {
                throw new IOException("Stream has been closed already.");
            }
            if (this.buffer == null) {
                return this.fillBuffer(false);
            }
            if (this.bufferPos >= this.buffer.length) {
                return this.fillBuffer(true);
            }
            return this.buffer.length - this.bufferPos;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int available = this.prepareBufferForRead();
            if (available < 1) {
                return -1;
            }
            int copiedBytes = Math.min(available, len);
            System.arraycopy(this.buffer, this.bufferPos, b, off, copiedBytes);
            this.bufferPos += copiedBytes;
            return copiedBytes;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read() throws IOException {
            int available = this.prepareBufferForRead();
            if (available < 1) {
                return -1;
            }
            int r = this.buffer[this.bufferPos++] & 0xFF;
            assert (r >= 0) : "Something goes awfully wrong here: byte value is negative.";
            return r;
        }

        public long skip(long n) throws IOException {
            if (n < 0L) {
                return 0L;
            }
            int available = this.available();
            if (n < (long)available) {
                this.bufferPos += (int)n;
                return n;
            }
            this.blobPos += n - (long)available;
            this.forceRefill();
            return n;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.buffer = null;
                this.closed = true;
                try {
                    this.connection.commit();
                    this.connection.close();
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                    throw new IOException("Couldn't close underlying database connection. Reason: " + e.getMessage());
                }
            }
        }

        public synchronized void mark(int readlimit) {
            this.mark = this.blobPos - (long)this.available();
        }

        private void forceRefill() {
            if (this.buffer != null) {
                this.bufferPos = this.buffer.length;
            }
        }

        public synchronized void reset() throws IOException {
            if (this.mark == -1L) {
                throw new IOException("Mark has not been set.");
            }
            this.blobPos = this.mark;
            this.forceRefill();
        }
    }
}

