/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.rdbmsImpl;

import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;

public class BlobStream
extends BaseLayerStream {
    Connection connection;

    public BlobStream(Blob blob, Connection connection) throws BaseLayerException {
        super(null, 0L);
        try {
            this.inputStream = blob.getBinaryStream();
            this.length = blob.length();
        }
        catch (SQLException sqle) {
            throw new BaseLayerException("Error while accessing BLOB from database.", sqle);
        }
        this.connection = connection;
    }

    public void dispose() throws BaseLayerException {
        try {
            this.inputStream.close();
            this.inputStream = null;
            this.length = 0L;
            this.connection.commit();
            this.connection.close();
        }
        catch (IOException ioe) {
            throw new BaseLayerException("Could not close input stream.", ioe);
        }
        catch (SQLException sqle) {
            throw new BaseLayerException("Unexpected error while accessing database.", sqle);
        }
    }
}

