/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.InstantiableManager;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.baselayer.inMessageImpl.InMemoryContentManager;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.layerindependent.servicehelper.CredentialsProvider;
import org.gcube.contentmanagement.layerindependent.servicehelper.CredentialsReceiver;

public class BaseLayerUtils
implements InstantiableManager {
    private static final Log log = LogFactory.getLog(BaseLayerUtils.class);
    private static final List REGISTERED_PROTOCOL_HANDLERS = new ArrayList();
    private static InMemoryContentManager mem = InMemoryContentManager.getInstance();
    public static final int CHAR_NOT_FOUND = -1;
    private static final Pattern urlSplitPattern;
    static final Class[] INVOCATION_PARAMS;
    @Deprecated
    public static final String HINT_NAME_COPY_TO_MESSAGE = "pending-copy-to-message";
    private static UUIDGen uuid;

    public static RawFileContentManager getInMemoryManager() {
        return mem;
    }

    public static Object instantiateManager(String managerClassName, String[] params, String managerName, CredentialsProvider provider) throws BaseLayerException {
        log.debug((Object)("Creating new instance of manager '" + managerClassName + "' (" + managerName + ")."));
        try {
            Class<?> theClass = Class.forName(managerClassName);
            Method instanciationMethod = theClass.getMethod("getManagerInstance", INVOCATION_PARAMS);
            Object[] invocationParams = new Object[]{params, managerName};
            Object manager = instanciationMethod.invoke(null, invocationParams);
            if (provider != null && manager instanceof CredentialsReceiver) {
                ((CredentialsReceiver)manager).setCredentialsProvider(provider);
            }
            return manager;
        }
        catch (ClassNotFoundException cnfe) {
            log.error((Object)cnfe);
            throw new BaseLayerException("Could not find appropriate class: " + managerClassName, cnfe);
        }
        catch (NullPointerException npe) {
            log.error((Object)(managerClassName + " does have a method " + "getManagerInstance" + ", but this does not seem to be defined static."));
            throw new BaseLayerException(managerClassName + " could not be instantiated, manager seems to be implemented improperly.");
        }
        catch (Exception e) {
            log.error((Object)e);
            Throwable cause = e.getCause();
            if (cause != null) {
                log.error((Object)"Caused by: ", cause);
            }
            throw new BaseLayerException(managerClassName + " could not be instantiated, probably it is not a valid manager or paramteres do not fit.", e);
        }
    }

    public static void registerProtocolHandler(String managerClassName, String[] params, String handlerName, CredentialsProvider provider) throws BaseLayerException {
        try {
            BaseLayerUtils.registerProtocolHandler((RawFileContentManager)BaseLayerUtils.instantiateManager(managerClassName, params, handlerName, provider));
        }
        catch (ClassCastException cce) {
            log.error((Object)(managerClassName + " is not a valid RawFileContentManager that could be used as a protocol handler."));
            log.debug((Object)cce);
            throw new BaseLayerException(managerClassName + " is not a valid RawFileContentManager that could be used as a protocol handler.", cce);
        }
    }

    public static void registerProtocolHandler(RawFileContentManager manager) {
        REGISTERED_PROTOCOL_HANDLERS.add(manager);
    }

    public static void registerProtocolHandler(RawFileContentManager manager, int position) {
        REGISTERED_PROTOCOL_HANDLERS.add(position, manager);
    }

    public static void unregisterProtocolHandler(int position) {
        REGISTERED_PROTOCOL_HANDLERS.remove(position);
    }

    public static RawFileContentManager getProtocolHandler(int position) {
        return (RawFileContentManager)REGISTERED_PROTOCOL_HANDLERS.get(position);
    }

    public static int getNumberOfProtocolHandlers() {
        return REGISTERED_PROTOCOL_HANDLERS.size();
    }

    public static RawFileContentManager getProtocolHandlerFor(String fileLocation, BasicStorageHints hints) throws ValueNotValidException {
        log.debug((Object)("searching protocol handler to manage location: " + fileLocation));
        for (RawFileContentManager manager : REGISTERED_PROTOCOL_HANDLERS) {
            if (!manager.handles(fileLocation)) continue;
            return manager;
        }
        throw new ValueNotValidException("Cannot find appropriate handler for location '" + fileLocation + "'!", fileLocation, "contentmanagement:location");
    }

    public static RawContentLocation getExternalLocation(String fileLocation, BasicStorageHints hints) throws ValueNotValidException {
        RawFileContentManager externalManager = BaseLayerUtils.getProtocolHandlerFor(fileLocation, hints);
        RawContentLocation currentLocation = new RawContentLocation(fileLocation, externalManager.getDataProvider());
        return externalManager.makePermanentLocation(currentLocation, hints);
    }

    public static boolean convertHintToBoolean(String hintValue, String hintName) throws ValueNotValidException {
        try {
            return Boolean.parseBoolean(hintValue);
        }
        catch (NumberFormatException nfe) {
            throw new ValueNotValidException("Not a boolean hint value", hintValue, hintName);
        }
    }

    public static int convertHintToInteger(String hintValue, String hintName) throws ValueNotValidException {
        try {
            return Integer.parseInt(hintValue);
        }
        catch (NumberFormatException nfe) {
            throw new ValueNotValidException("Not a integer hint value", hintValue, hintName);
        }
    }

    public static long convertHintToLong(String hintValue, String hintName) throws ValueNotValidException {
        try {
            return Long.parseLong(hintValue);
        }
        catch (NumberFormatException nfe) {
            throw new ValueNotValidException("Not a long hint value", hintValue, hintName);
        }
    }

    public static float convertHintToFloat(String hintValue, String hintName) throws ValueNotValidException {
        try {
            return Float.parseFloat(hintValue);
        }
        catch (NumberFormatException nfe) {
            throw new ValueNotValidException("Not a float hint value", hintValue, hintName);
        }
    }

    public static double convertHintToDouble(String hintValue, String hintName) throws ValueNotValidException {
        try {
            return Double.parseDouble(hintValue);
        }
        catch (NumberFormatException nfe) {
            throw new ValueNotValidException("Not a double hint value", hintValue, hintName);
        }
    }

    public static boolean requestsFor(String hintName, BasicStorageHints hints) throws ValueNotValidException {
        if (hints == null) {
            return false;
        }
        String hintValue = hints.getHintValue(hintName);
        if (hintValue != null) {
            return BaseLayerUtils.convertHintToBoolean(hintValue, hintName);
        }
        return false;
    }

    public static boolean consumeHint(String hintName, BasicStorageHints hints) throws ValueNotValidException {
        if (hints == null) {
            return false;
        }
        if (hints.hasHint(hintName)) {
            hints.markHint(hintName, true);
            return true;
        }
        return false;
    }

    public static boolean containsDownloadCredentials(BasicStorageHints downloadHints) {
        if (downloadHints == null) {
            return false;
        }
        return downloadHints.hasHint("user") || downloadHints.hasHint("passwd");
    }

    public static String getNewUUID() {
        return uuid.nextUUID();
    }

    public static String removeProtocolUsernamePasswordFromURL(String url) {
        String[] parts = urlSplitPattern.split(url);
        if (parts != null && parts.length > 1) {
            return parts[1];
        }
        log.debug((Object)("URL does not even contain protocol part: " + url + "- nothing removed."));
        return url;
    }

    public static RawContentLocation makePseudoUniqueLocation(RawContentLocation location, RawFileContentManager manager, BasicStorageHints hints) throws BaseLayerException {
        boolean underscored = false;
        StringBuffer newID = new StringBuffer(location.getContentID());
        while (manager.existsBinaryContent(location, hints)) {
            if (!underscored) {
                newID.append('_');
                underscored = true;
            }
            newID.append((int)(Math.random() * 100.0));
            location.setContentID(newID.toString());
        }
        return location;
    }

    static {
        BaseLayerUtils.registerProtocolHandler(mem);
        urlSplitPattern = Pattern.compile(":/*(?:\\w+(?::\\w+)?@)?");
        INVOCATION_PARAMS = new Class[2];
        BaseLayerUtils.INVOCATION_PARAMS[0] = new String[0].getClass();
        BaseLayerUtils.INVOCATION_PARAMS[1] = String.class;
        uuid = UUIDGenFactory.getUUIDGen();
    }
}

