/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.streamutils;

import java.io.IOException;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.streamutils.FinishingAction;
import org.gcube.contentmanagement.baselayer.streamutils.FinishingActionStream;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;

public class DeleteContentAction
implements FinishingAction {
    private final RawFileContentManager MANAGER;
    private final RawContentLocation LOCATION;
    private final BasicStorageHints HINTS;
    private final boolean DELETE_EVEN_IF_STREAM_UNREAD;

    public DeleteContentAction(RawFileContentManager manager, RawContentLocation locationToDelete, BasicStorageHints hints, boolean deleteIfStreamUnread) {
        this.MANAGER = manager;
        this.LOCATION = locationToDelete;
        this.HINTS = hints;
        this.DELETE_EVEN_IF_STREAM_UNREAD = deleteIfStreamUnread;
    }

    public void finish(FinishingActionStream fas) throws IOException {
        if (!this.DELETE_EVEN_IF_STREAM_UNREAD && fas.getCount() == 0L) {
            return;
        }
        try {
            this.MANAGER.deleteBinaryContent(this.LOCATION, this.HINTS);
        }
        catch (BaseLayerException ble) {
            throw new IOException(ble.getMessage());
        }
    }
}

