/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.inMessageImpl;

import java.io.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.InstantiableManager;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.baselayer.inMessageImpl.InMemoryContentStream;
import org.gcube.contentmanagement.baselayer.inMessageImpl.InMemoryRawContentLocation;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;

public class InMemoryContentManager
implements RawFileContentManager,
InstantiableManager {
    private static final Log log = LogFactory.getLog(InMemoryContentManager.class);
    static final String DATA_PROVIDER_PREFIX = "inmessage://";
    static InMemoryContentManager instance = null;

    private InMemoryContentManager() {
    }

    public static synchronized InMemoryContentManager getInstance() {
        if (instance == null) {
            instance = new InMemoryContentManager();
        }
        return instance;
    }

    public RawContentLocation saveBinaryContent(String uniqueStorageID, BaseLayerStream binaryFileContent, BasicStorageHints hints) throws BaseLayerException {
        return new InMemoryRawContentLocation(uniqueStorageID, DATA_PROVIDER_PREFIX, this.copyBytes(binaryFileContent));
    }

    private byte[] copyBytes(BaseLayerStream binaryFileContent) throws BaseLayerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InMemoryContentStream.copyBytes(binaryFileContent, baos);
        byte[] content = baos.toByteArray();
        binaryFileContent.dispose();
        return content;
    }

    public RawContentLocation storeBytes(String uniqueStorageID, byte[] content, BasicStorageHints hints) {
        return new InMemoryRawContentLocation(uniqueStorageID, DATA_PROVIDER_PREFIX, content);
    }

    public RawContentLocation storeBytes(byte[] content, BasicStorageHints hints) {
        return this.storeBytes(BaseLayerUtils.getNewUUID(), content, hints);
    }

    public byte[] getBytes(InMemoryRawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        return location.getContent();
    }

    public BaseLayerStream getBinaryContent(RawContentLocation location, BasicStorageHints hints) {
        return new InMemoryContentStream(((InMemoryRawContentLocation)location).getContent());
    }

    public BaseLayerStream getBinaryContent(byte[] bytes, BasicStorageHints hints) {
        return new InMemoryContentStream(bytes);
    }

    public boolean deleteBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        InMemoryRawContentLocation loc = (InMemoryRawContentLocation)location;
        boolean result = loc.getContent() != null;
        loc.setContent(null);
        return result;
    }

    public boolean existsBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        return ((InMemoryRawContentLocation)location).getContent() != null;
    }

    public boolean handles(String dataprovider) {
        if (dataprovider == null) {
            return false;
        }
        return dataprovider.equalsIgnoreCase(this.getDataProvider());
    }

    public String getDataProvider() {
        return DATA_PROVIDER_PREFIX;
    }

    public boolean supportsAppending() {
        return false;
    }

    public RawContentLocation makePermanentLocation(RawContentLocation currentLocation, BasicStorageHints hints) throws ValueNotValidException {
        throw new ValueNotValidException("Content tranfered via " + this.getDataProvider() + " is volatile and can never be permanent.", "make permanent", "contentmanagement:location");
    }

    public static InMemoryContentManager getManagerInstance(String[] params, String managerName) throws BaseLayerException {
        return InMemoryContentManager.getInstance();
    }

    public String getUniqueStorageLocationIDFor(String objectID) {
        return objectID;
    }
}

