/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storage.data.transfer.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;

public class Utils {
    public static IClient getProductionStorageClient() {
        IClient prodClient = null;
        ScopeProvider.instance.set("/d4science.research-infrastructures.eu");
        try {
            prodClient = new StorageClient("org.gcube.portlets.user", "home-library", "home-library", AccessType.SHARED).getClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prodClient;
    }

    public static IClient getDevStorageClient() {
        IClient prodClient = null;
        ScopeProvider.instance.set("/gcube");
        try {
            prodClient = new StorageClient("org.gcube.portlets.user", "home-library", "home-library", AccessType.SHARED).getClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prodClient;
    }

    public static IClient getBackupStorageClient(String serverIp, String scope) {
        ScopeProvider.instance.set(scope);
        IClient backupClient = null;
        try {
            backupClient = new StorageClient("org.gcube.portlets.user", "home-library", "home-library", AccessType.SHARED, MemoryType.PERSISTENT, serverIp).getClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return backupClient;
    }

    public static void csvParseAndTransfer(String strFile, String serverIp) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(strFile));
            String strLine = "";
            StringTokenizer st = null;
            int lineNumber = 0;
            int tokenNumber = 0;
            while ((strLine = br.readLine()) != null) {
                ++lineNumber;
                st = new StringTokenizer(strLine, "###");
                while (st.hasMoreTokens()) {
                    if (++tokenNumber == 2) {
                        String remotePath = st.nextToken();
                        System.out.println("remotePath: " + remotePath);
                        if (remotePath == null || remotePath.length() <= 0) continue;
                        try {
                            IClient backClient = Utils.getBackupStorageClient(serverIp, "/d4science.research-infrastructures.eu");
                            InputStream is = backClient.get().RFileAsInputStream(remotePath);
                            if (is != null) {
                                IClient prodClient = Utils.getProductionStorageClient();
                                prodClient.put(true).LFile(is).RFile(remotePath);
                                is.close();
                                System.out.println("file transferred: " + remotePath);
                                continue;
                            }
                            System.out.println(" file not transferred: " + remotePath);
                        }
                        catch (Exception e) {
                            System.out.println("Error occurs while parsing file : " + remotePath);
                        }
                        continue;
                    }
                    st.nextToken();
                }
                tokenNumber = 0;
            }
            System.out.println("# lines: " + lineNumber);
        }
        catch (Exception e) {
            System.out.println("Exception while reading csv file " + strFile + ": " + e);
        }
    }

    public static void transferFromCol1ToCol2(String strFile, String serverIp) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(strFile));
            String strLine = "";
            StringTokenizer st = null;
            int lineNumber = 0;
            int tokenNumber = 0;
            while ((strLine = br.readLine()) != null) {
                ++lineNumber;
                st = new StringTokenizer(strLine, "###");
                String remotePathBackup = null;
                while (st.hasMoreTokens()) {
                    if (++tokenNumber == 1) {
                        remotePathBackup = st.nextToken();
                        continue;
                    }
                    if (tokenNumber == 2) {
                        String remotePath = st.nextToken();
                        System.out.println("remotePath: " + remotePath);
                        if (remotePath == null || remotePath.length() <= 0 || remotePathBackup == null || remotePathBackup.length() <= 0) continue;
                        try {
                            System.out.println("Sostitution:");
                            System.out.println("remotePath: " + remotePath);
                            System.out.println("backup: " + remotePathBackup);
                            IClient backClient = Utils.getBackupStorageClient(serverIp, "/d4science.research-infrastructures.eu");
                            InputStream is = backClient.get().RFileAsInputStream(remotePathBackup);
                            if (is != null) {
                                IClient prodClient = Utils.getProductionStorageClient();
                                prodClient.put(true).LFile(is).RFile(remotePath);
                                is.close();
                                System.out.println("file transferred: " + remotePathBackup);
                                continue;
                            }
                            System.out.println(" file not transferred: " + remotePathBackup);
                        }
                        catch (Exception e) {
                            System.out.println("Error occurs while parsing file : " + remotePath);
                        }
                        continue;
                    }
                    st.nextToken();
                }
                tokenNumber = 0;
            }
            System.out.println("# lines: " + lineNumber);
        }
        catch (Exception e) {
            System.out.println("Exception while reading csv file " + strFile + ": " + e);
        }
    }
}

