/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.IOException;
import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriter
extends Thread {
    final Logger logger = LoggerFactory.getLogger(FileWriter.class);
    private Monitor monitor;
    private int id;
    private MyFile myFile;
    private byte[] encode;
    private int offset;
    private static int len = 0;
    private OutputStream out;
    private String path;
    private byte[] full;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("run() - start");
        }
        MyFile request = this.monitor.getRequest();
        Class<FileWriter> clazz = FileWriter.class;
        synchronized (FileWriter.class) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("recover request: " + request.getKey() + " length: " + request.getContent().length);
            }
            try {
                this.decodeByte2File(request.getContent());
                this.out.flush();
            }
            catch (Exception e) {
                this.logger.error("run()", e);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("run() - end");
            }
            return;
        }
    }

    public FileWriter(Monitor monitor, OutputStream out, byte[] fullEncode) {
        this.monitor = monitor;
        this.out = out;
        this.full = fullEncode;
    }

    public FileWriter(Monitor monitor, OutputStream out) {
        this.monitor = monitor;
        this.out = out;
    }

    public FileWriter(Monitor monitor, int id) {
        this.monitor = monitor;
        this.id = id;
    }

    public void decodeByte2File(byte[] encode, int offset, int len) {
        try {
            this.out.write(encode, offset, len);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("write from pos:" + offset + " to pos: " + len);
            }
        }
        catch (IOException e) {
            this.logger.error("decodeByte2File(byte[], int, int)", e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New file created!");
        }
    }

    public void decodeByte2File(byte[] encode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("decodeByte2File(byte[]) - start");
            this.logger.debug("encode.length: " + encode.length);
        }
        try {
            this.out.write(encode);
        }
        catch (Exception e) {
            this.logger.error("scrittura chunk non riuscita!!");
            this.logger.error("decodeByte2File(byte[])", e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("decodeByte2File(byte[]) - end");
        }
    }
}

