package org.gcube.contentmanagement;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

import org.apache.log4j.Logger;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.ExternalResourceLinkPlugin;
import org.gcube.common.homelibrary.home.workspace.exceptions.ExternalResourceBrokenLinkException;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnection;

public class StorageManagerResourcePlugin implements ExternalResourceLinkPlugin {

	protected static final Logger logger = Logger
			.getLogger(StorageManagerResourcePlugin.class);

	public String getPluginName() {
		// TODO Auto-generated method stub
		return getClass().getName();
	}

	public InputStream getContent(ExternalResourceLink item)
			throws ExternalResourceBrokenLinkException, InternalErrorException {

		String url = item.getResourceId();
		
		try {

			if (url == null || url.isEmpty())
				throw new ExternalResourceBrokenLinkException("Link " + url
						+ " is null or empty");

			URLConnection urlConnection = getURLConnectionByStorageClient(url);
			return urlConnection.getInputStream();

		} catch (MalformedURLException e) {
			throw new InternalErrorException(e.getMessage());
		} catch (Exception e) {
			throw new InternalErrorException(e.getMessage());
		}

	}

	public URLConnection getURLConnectionByStorageClient(String url) throws Exception {

		Handler.activateProtocol();

		URL smsHome = null;
		try {

			smsHome = new URL(null, url, new URLStreamHandler() {

				@Override
				protected URLConnection openConnection(URL u)
						throws IOException {
					return new SMPURLConnection(u);
				}
			});

		} catch (MalformedURLException e1) {
			logger.error("MalformedURLException was fired", e1);
			throw new Exception("MalformedURLException was fired");
		}

		try {
			
		
		return (URLConnection) smsHome.openConnection();
		
		} catch (IOException e) {
			logger.error("IOException was fired", e);
			throw new Exception("IOException was fired");
		}
		
	}

	public static String extractLocation(String url) {
		String[] loc = url.split("//");
		return loc[1];
	}

	@Override
	public long getSize(ExternalResourceLink item)
			throws ExternalResourceBrokenLinkException, InternalErrorException {

		String url = item.getResourceId();
		try {

			if (url == null || url.isEmpty())
				throw new ExternalResourceBrokenLinkException("Link " + url
						+ " is null or empty");

			URLConnection urlConnection = getURLConnectionByStorageClient(url);
			return urlConnection.getContentLength();
		} catch (ExternalResourceBrokenLinkException e) {
			throw new ExternalResourceBrokenLinkException(e.getMessage());
		} catch (Exception e) {
			throw new InternalErrorException(e.getMessage());
		}

	}
}
