/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.wrapper;

import java.security.Key;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanager.storageclient.wrapper.ISClientConnector;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static String clientID;
    private String typeAccess;
    private String memoryType;
    private String owner;
    private String scopeString;
    private String clientId;
    private String server;
    private String environment;
    private String sc;
    private String sn;
    private String user;
    private String password;
    private String passPhrase;
    private ISClientConnector isclient;
    private String RRScope;
    private String backendType;
    private String[] volatileHost;
    private String[] persistentHosts;
    private String resolverHost;
    private static final Logger logger;
    private static final String DEFAULT_BACKEND_TYPE = "MongoDB";
    private static final String WRITE_CONCERN_PROPERTY_NAME = "write_concern";
    private static final String READ_PREFERENCE_PROPERTY_NAME = "read_preference";
    private static final String HOME_LIBRARY_SERVICE_CLASS = "org.gcube.portlets.user";
    private static final String HOME_LIBRARY_SERVICE_NAME_DEV = "";
    private static final String HOME_LIBRARY_SERVICE_NAME_PROD = "";
    private static final String HL_CONTEXT = "/d4science.research-infrastructures.eu";

    public Configuration(String sc, String sn, String scopeString, String clientId, String owner, String accessType, String memory) {
        this.sc = sc;
        this.sn = sn;
        this.owner = owner;
        this.typeAccess = accessType;
        this.memoryType = memory;
        this.setScopeString(scopeString);
        clientID = clientId;
    }

    public void getConfiguration() {
        String[] newServer = null;
        ISClientConnector isclient = new ISClientConnector();
        String currentScope = ScopeProvider.instance.get();
        logger.debug("Scope found on ScopeProvider instance is " + currentScope);
        if (this.RRScope == null) {
            if (new ScopeBean(currentScope).is(ScopeBean.Type.VRE)) {
                logger.debug("If ScopeProvider scope is VRE scope RR scope became VO scope");
                this.RRScope = new ScopeBean(currentScope).enclosingScope().toString();
            } else {
                logger.debug("If ScopeProvider scope is not a VRE scope RR scope is ScopeProvider scope");
                this.RRScope = currentScope;
            }
        }
        logger.debug("RuntimeResource scope " + this.RRScope);
        List<ServiceEndpoint> resources = isclient.getStorageEndpoint(this.RRScope);
        if (resources == null) {
            throw new IllegalStateException("the storage resource is not present on IS in scope: " + this.RRScope);
        }
        List<ServiceEndpoint> resolverResource = isclient.getServiceEndpoint("Service", "HTTP-URI-Resolver");
        if (resolverResource == null || resolverResource.size() <= 0) {
            throw new IllegalStateException("the uri resolver resource is not present on IS in scope: " + currentScope);
        }
        this.setResolverHost(isclient.getResolverHost(resolverResource.get(0)));
        if (this.server == null) {
            logger.debug("server not set. Try to query IS in scope: " + this.scopeString);
            String[] serverFound = Configuration.checkVarEnvMongo();
            if (serverFound == null) {
                serverFound = isclient.getPrimaryServer(resources);
                this.user = isclient.username;
                this.password = isclient.password;
                this.backendType = isclient.getBackendType(resources);
            } else {
                this.backendType = Configuration.checkVarEnvBackendType();
                if (this.backendType == null) {
                    this.backendType = DEFAULT_BACKEND_TYPE;
                }
                this.user = Configuration.checkVarEnvUser();
                this.password = Configuration.checkVarEnvPassword();
            }
            newServer = serverFound;
        } else {
            String[] serverPassed;
            logger.debug("server found: " + this.server);
            newServer = serverPassed = new String[]{this.server};
            if (this.backendType == null) {
                this.backendType = DEFAULT_BACKEND_TYPE;
            }
        }
        if (newServer == null) {
            throw new IllegalStateException("Resource not found on Information System");
        }
        this.environment = this.setAreaStorage(this.sc, this.sn);
        this.setServerHosts(newServer, isclient, resources);
        try {
            this.passPhrase = Configuration.retrieveEncryptionPhrase(currentScope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setServerHosts(String[] newServer, ISClientConnector isclient, List<ServiceEndpoint> resources) {
        if (this.memoryType != null && (this.memoryType.equals(MemoryType.VOLATILE.toString()) || this.memoryType.equals(MemoryType.BOTH.toString()))) {
            this.volatileHost = isclient.getVolatileHost(resources);
            logger.info("backend host is the volatile server" + this.volatileHost[0]);
        }
        this.persistentHosts = newServer;
    }

    private String setAreaStorage(String sc, String sn) {
        String area = null;
        if (this.isHomeLibrary(sc, sn)) {
            return this.getHomeLibraryContext();
        }
        area = this.memoryType != null && this.memoryType.equals(MemoryType.VOLATILE.toString()) ? "VOLATILE" + this.scopeString + clientID : this.scopeString + clientID;
        return area;
    }

    private boolean isHomeLibrary(String sc, String sn) {
        return sc.equals(HOME_LIBRARY_SERVICE_CLASS) && sn.equals("") || sc.equals(HOME_LIBRARY_SERVICE_CLASS) && sn.equals("");
    }

    private String getHomeLibraryContext() {
        String area = null;
        area = this.memoryType != null && this.memoryType.equals(MemoryType.VOLATILE.toString()) ? "VOLATILE/d4science.research-infrastructures.eu" + clientID : HL_CONTEXT + clientID;
        return area;
    }

    protected void readWRPropertiesFromRR(String currentScope, ServiceEngine engine) {
        String write = null;
        String read = null;
        if (this.memoryType != null && !this.memoryType.equals(MemoryType.VOLATILE.toString())) {
            write = this.getISClient().retrievePropertyValue(WRITE_CONCERN_PROPERTY_NAME, currentScope);
            read = this.isclient.retrievePropertyValue(READ_PREFERENCE_PROPERTY_NAME, currentScope);
            if (write != null && read != null) {
                engine.setWriteConcern(write);
                engine.setReadConcern(read);
            }
        }
    }

    private static String[] checkVarEnvMongo() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String server = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_MONGO_SERVER")) continue;
            server = env.get(key);
            break;
        }
        if (server != null) {
            String[] servers = new String[]{server};
            return servers;
        }
        return null;
    }

    private static String checkVarEnvBackendType() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String type = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_BACKEND_TYPE")) continue;
            type = env.get(key);
            break;
        }
        if (type != null) {
            return type;
        }
        return null;
    }

    private static String checkVarEnvUser() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String type = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_USER")) continue;
            type = env.get(key);
            break;
        }
        if (type != null) {
            return type;
        }
        return null;
    }

    private static String checkVarEnvPassword() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String type = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_PASSWORD")) continue;
            type = env.get(key);
            break;
        }
        if (type != null) {
            return type;
        }
        return null;
    }

    private static String retrieveEncryptionPhrase(String rootScope) throws Exception {
        String currentScope = ScopeProvider.instance.get();
        String scope = rootScope;
        logger.debug("scope used for retrieving  Storage resource is: " + currentScope);
        String encryptedKey = null;
        ISClientConnector isclient = new ISClientConnector();
        encryptedKey = isclient.retrievePropertyValue("PassPhrase", scope);
        String decryptString = StringEncrypter.getEncrypter().decrypt(encryptedKey, new Key[0]);
        return decryptString;
    }

    public static String getClientID() {
        return clientID;
    }

    public void setClientID(String clientID) {
        Configuration.clientID = clientID;
    }

    public String getTypeAccess() {
        return this.typeAccess.toString();
    }

    public void setTypeAccess(String typeAccess) {
        this.typeAccess = typeAccess;
    }

    public String getMemoryType() {
        return this.memoryType.toString();
    }

    public void setMemoryType(String memoryType) {
        this.memoryType = memoryType;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String server) {
        this.environment = server;
    }

    public String getScopeString() {
        return this.scopeString;
    }

    public void setScopeString(String scopeString) {
        this.scopeString = scopeString;
    }

    public String getRRScope() {
        return this.RRScope;
    }

    public void setRRScope(String rRScope) {
        this.RRScope = rRScope;
    }

    public String getBackendType() {
        return this.backendType;
    }

    public void setBackendType(String backendType) {
        this.backendType = backendType;
    }

    public String[] getVolatileHost() {
        return this.volatileHost;
    }

    public void setVolatileHost(String[] volatileHost) {
        this.volatileHost = volatileHost;
    }

    public String[] getPersistentHosts() {
        return this.persistentHosts;
    }

    public void setPersistentHosts(String[] hosts) {
        this.persistentHosts = hosts;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getResolverHost() {
        return this.resolverHost;
    }

    public void setResolverHost(String resolverHost) {
        this.resolverHost = resolverHost;
    }

    public ISClientConnector getISClient() {
        if (this.isclient == null) {
            this.isclient = new ISClientConnector();
        }
        return this.isclient;
    }

    static {
        logger = LoggerFactory.getLogger(StorageClient.class);
    }
}

