package org.gcube.contentmanager.storageclient.model.protocol.smp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

/**
 * An extension of URLConnection used for smp url
 * @author roberto.cirillo
 *
 */
public abstract class SMPConnection extends URLConnection {

	public SMPConnection(URL url) {
		super(url);
	}

	/**{@inheritDoc}*/
	@Override
	public synchronized void connect() throws IOException {
			
			try {
	//			node = ReadManagerCall.get(url.toURI(),GCUBEScopeManager.DEFAULT.getScope());
				connected=true;
			}
			catch (Exception e) {
				e.printStackTrace();
				IOException ioe = new IOException();
				ioe.initCause(e);
				throw ioe;
			}
		}
	
	@Override
	public abstract InputStream getInputStream() throws IOException;
	
	
	protected abstract InputStream storageClient(String url) throws Exception;

}