/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.store;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.gcube.contentmanager.storageserver.store.StorageStatusObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageStatusOperationManager {
    DBCollection ssCollection;
    Logger logger = LoggerFactory.getLogger(StorageStatusOperationManager.class);

    public StorageStatusOperationManager(DBCollection ssCollection) {
        this.setSsCollection(ssCollection);
    }

    public void putSSRecord(String consumer, long volume, int count) {
        this.logger.debug("put ss record method");
        BasicDBObject doc = new BasicDBObject("consumer", (Object)consumer).append("volume", (Object)volume).append("count", (Object)count);
        DBCollection collection = this.getSsCollection();
        this.logger.info("put ss record [" + consumer + " " + volume + " " + count + " ] in collection: " + collection);
        collection.insert(new DBObject[]{doc});
    }

    public StorageStatusObject updateUser(StorageStatusObject ssRecord, String lastOperation) {
        String consumer = ssRecord.getConsumer();
        this.logger.debug("check counts and volume for user " + consumer);
        StorageStatusObject oldSsr = this.getSSRecord(consumer);
        if (oldSsr != null) {
            this.logger.debug("user already present");
            int partialCount = oldSsr.getCount();
            this.logger.info(consumer + " count found on db " + partialCount);
            int count = this.countCalculation(ssRecord.getCount(), partialCount, lastOperation);
            ssRecord.setCount(count);
            long partialVolume = oldSsr.getVolume();
            this.logger.info(consumer + " volume found on db " + partialVolume);
            long volume = this.volumeCalculation(ssRecord.getVolume(), partialVolume, lastOperation);
            ssRecord.setVolume(volume);
            BasicDBObject query = new BasicDBObject("consumer", (Object)consumer);
            DBObject documentBuilder = BasicDBObjectBuilder.start().add("volume", (Object)volume).add("count", (Object)count).get();
            this.getSsCollection().update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)documentBuilder), true, false);
        } else {
            this.logger.debug("user not present on db");
            this.putSSRecord(consumer, ssRecord.getVolume(), ssRecord.getCount());
        }
        return ssRecord;
    }

    public StorageStatusObject overwriteUser(String consumer, String count, String volume) {
        StorageStatusObject oldSsr = this.getSSRecord(consumer);
        BasicDBObject query = new BasicDBObject("consumer", (Object)consumer);
        DBObject documentBuilder = BasicDBObjectBuilder.start().add("volume", (Object)volume).add("count", (Object)count).get();
        this.getSsCollection().update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)documentBuilder), true, false);
        StorageStatusObject newSsr = this.getSSRecord(consumer);
        return newSsr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageStatusObject getSSRecord(String consumer) {
        BasicDBObject query = new BasicDBObject("consumer", (Object)consumer);
        DBObject obj = null;
        try (DBCursor cursor = this.getSsCollection().find((DBObject)query);){
            if (cursor.hasNext()) {
                obj = cursor.next();
            }
        }
        if (obj != null) {
            String cons = null;
            if (obj.containsField("consumer")) {
                cons = (String)obj.get("consumer");
            } else {
                this.logger.error("incomplete record found. consumer field is missing");
            }
            long vol = 0L;
            if (obj.containsField("volume")) {
                vol = (Long)obj.get("volume");
            } else {
                this.logger.error("incomplete record found. volume field is missing");
            }
            int count = 0;
            if (obj.containsField("count")) {
                count = (Integer)obj.get("count");
            } else {
                this.logger.error("incomplete record found. count field is missing");
            }
            String id = (String)obj.get("id");
            return new StorageStatusObject(id, cons, vol, count, obj);
        }
        return null;
    }

    private long volumeCalculation(long currentVolume, long partialVolume, String operation) {
        this.logger.info("accounting: operation " + operation + " total Volume " + partialVolume + " current volume " + currentVolume);
        if (operation.equalsIgnoreCase("UPLOAD") || operation.equalsIgnoreCase("COPY") || operation.equalsIgnoreCase("SOFT_COPY")) {
            partialVolume += currentVolume;
        } else if (operation.equalsIgnoreCase("DELETE")) {
            partialVolume -= currentVolume;
        }
        this.logger.info("new volume " + partialVolume);
        return partialVolume;
    }

    private int countCalculation(int current, int partial, String operation) {
        this.logger.info("accounting: operation " + operation + " old count " + partial + " current count" + current);
        if (operation.equalsIgnoreCase("UPLOAD") || operation.equalsIgnoreCase("COPY") || operation.equalsIgnoreCase("SOFT_COPY")) {
            partial += current;
        } else if (operation.equalsIgnoreCase("DELETE")) {
            partial -= current;
        }
        this.logger.info("new count: " + partial);
        return partial;
    }

    public DBCollection getSsCollection() {
        return this.ssCollection;
    }

    public DBCursor getSsCollectionList() {
        return this.ssCollection.find();
    }

    public void setSsCollection(DBCollection ssCollection) {
        this.ssCollection = ssCollection;
    }
}

