/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.ByteBufOutputStream;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.subdoc.MultiValue;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import com.couchbase.client.java.transcoder.subdoc.AbstractFragmentTranscoder;
import java.io.IOException;
import java.util.Iterator;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class JacksonFragmentTranscoder
extends AbstractFragmentTranscoder {
    private final ObjectMapper mapper;

    public JacksonFragmentTranscoder(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> T decodeWithMessage(ByteBuf encoded, Class<? extends T> clazz, String transcodingErrorMessage) throws TranscodingException {
        try {
            if (Object.class.equals(clazz)) {
                return (T)TranscoderUtils.byteBufToGenericObject(encoded, this.mapper);
            }
            return TranscoderUtils.byteBufToClass(encoded, clazz, this.mapper);
        }
        catch (IOException e) {
            throw new TranscodingException(transcodingErrorMessage, e);
        }
    }

    @Override
    protected <T> ByteBuf doEncodeSingle(T value, String transcodingErrorMessage) throws TranscodingException {
        try {
            return Unpooled.wrappedBuffer(this.mapper.writeValueAsBytes(value));
        }
        catch (JsonProcessingException e) {
            throw new TranscodingException(transcodingErrorMessage, e);
        }
    }

    @Override
    protected ByteBuf doEncodeMulti(MultiValue<?> multiValue, String transcodingErrorMessage) throws TranscodingException {
        ByteBufOutputStream out = new ByteBufOutputStream(Unpooled.buffer(4 * multiValue.size()));
        try {
            Iterator<?> iterator = multiValue.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                this.mapper.writeValue(out, o);
                if (!iterator.hasNext()) continue;
                out.writeBytes(",");
            }
            return out.buffer();
        }
        catch (IOException e) {
            throw new TranscodingException(transcodingErrorMessage, e);
        }
    }
}

