/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.query.SearchQuery;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class StringQuery
extends SearchQuery {
    private final String query;

    protected StringQuery(Builder builder) {
        super(builder);
        this.query = builder.query;
    }

    public static Builder on(String index) {
        return new Builder(index);
    }

    public String query() {
        return this.query;
    }

    @Override
    public double boost() {
        return this.boost;
    }

    @Override
    public JsonObject queryJson() {
        return JsonObject.create().put("query", this.query);
    }

    public static class Builder
    extends SearchQuery.Builder {
        private String query;

        protected Builder(String index) {
            super(index);
        }

        @Override
        public StringQuery build() {
            return new StringQuery(this);
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }
    }
}

