/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.query.SearchQuery;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class FuzzyQuery
extends SearchQuery {
    private static final int PREFIX_LENGTH = 0;
    private static final int FUZZINESS = 2;
    private final String term;
    private final String field;
    private final int prefixLength;
    private final int fuzziness;

    protected FuzzyQuery(Builder builder) {
        super(builder);
        this.term = builder.term;
        this.prefixLength = builder.prefixLength;
        this.fuzziness = builder.fuzziness;
        this.field = builder.field;
    }

    public static Builder on(String index) {
        return new Builder(index);
    }

    public String term() {
        return this.term;
    }

    public String field() {
        return this.field;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public int fuzziness() {
        return this.fuzziness;
    }

    @Override
    public JsonObject queryJson() {
        return JsonObject.create().put("term", this.term).put("field", this.field).put("prefix_length", this.prefixLength).put("fuzziness", this.fuzziness);
    }

    public static class Builder
    extends SearchQuery.Builder {
        private String term;
        private String field;
        private int prefixLength = 0;
        private int fuzziness = 2;

        protected Builder(String index) {
            super(index);
        }

        @Override
        public FuzzyQuery build() {
            return new FuzzyQuery(this);
        }

        public Builder fuzziness(int fuzziness) {
            this.fuzziness = fuzziness;
            return this;
        }

        public Builder term(String term) {
            this.term = term;
            return this;
        }

        public Builder prefixLength(int prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }
    }
}

