/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.query.AsyncN1qlQueryRow;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import java.io.IOException;

public class DefaultAsyncN1qlQueryRow
implements AsyncN1qlQueryRow {
    private static final ObjectMapper OBJECT_MAPPER = JacksonTransformers.MAPPER;
    private JsonObject value = null;
    private final byte[] byteValue;

    public DefaultAsyncN1qlQueryRow(byte[] value) {
        this.byteValue = value;
    }

    @Override
    public byte[] byteValue() {
        return this.byteValue;
    }

    @Override
    public JsonObject value() {
        if (this.byteValue == null) {
            return null;
        }
        if (this.value == null) {
            try {
                this.value = OBJECT_MAPPER.readValue(this.byteValue, JsonObject.class);
                return this.value;
            }
            catch (IOException e) {
                throw new TranscodingException("Error deserializing row value from bytes to JsonObject", e);
            }
        }
        return this.value;
    }

    public String toString() {
        return this.byteValue == null ? "null" : this.value().toString();
    }
}

