/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackPersistenceBackend
extends PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(FallbackPersistenceBackend.class);
    private File fallbackFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getFallbackFile() {
        File file = this.fallbackFile;
        synchronized (file) {
            return this.fallbackFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected File getOldFallbackFile() {
        File file = this.fallbackFile;
        synchronized (file) {
            String oldAccountingFileName = this.fallbackFile.getName();
            int lastIndexOf_ = oldAccountingFileName.lastIndexOf("_");
            oldAccountingFileName = oldAccountingFileName.substring(lastIndexOf_ + 1);
            oldAccountingFileName = oldAccountingFileName.replace("fallback.log", "accountingFallback.log");
            return new File(this.fallbackFile.getParentFile(), oldAccountingFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File moveFallbackFile(String suffix) {
        File file = this.fallbackFile;
        synchronized (file) {
            try {
                Path source = this.fallbackFile.toPath();
                if (!this.fallbackFile.exists()) {
                    logger.trace("No fallback file {} found. Nothing to recover", (Object)source.toAbsolutePath().toString());
                    return null;
                }
                Path target = source.resolveSibling(this.fallbackFile.getName() + suffix);
                logger.trace("Going to move fallback file {} to {}", (Object)source.toAbsolutePath().toString(), (Object)target.toAbsolutePath().toString());
                target = Files.move(source, source.resolveSibling(this.fallbackFile.getName() + suffix), StandardCopyOption.ATOMIC_MOVE);
                return target.toFile();
            }
            catch (Exception e) {
                String absPath = this.fallbackFile.getAbsolutePath();
                String error = String.format("It was not possibile to move %s to %s%s.", absPath, absPath, suffix);
                logger.error(error, e);
                return null;
            }
        }
    }

    protected FallbackPersistenceBackend(File fallbackFile) {
        super(null);
        this.fallbackFile = fallbackFile;
    }

    @Override
    public void prepareConnection(PersistenceBackendConfiguration configuration) {
    }

    @Override
    protected void openConnection() throws Exception {
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    protected void accountWithFallback(Record ... records) throws Exception {
        for (Record record : records) {
            try {
                this.reallyAccount(record);
                logger.trace("{} accounted succesfully from {}", (Object)record.toString(), (Object)FallbackPersistenceBackend.class.getSimpleName());
            }
            catch (Throwable th) {
                logger.error("{} was not accounted at all", (Object)record.toString(), (Object)th);
            }
        }
    }

    @Override
    protected void reallyAccount(Record record) {
        String marshalled = null;
        try {
            marshalled = DSMapper.marshal(record);
            this.printLine(marshalled);
            logger.trace("{} accounted succesfully from {}", (Object)marshalled, (Object)this.getClass().getSimpleName());
        }
        catch (Throwable th) {
            logger.error("{} was not accounted at all", (Object)(marshalled != null ? marshalled : record.toString()), (Object)th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printLine(String line) throws Exception {
        File file = this.fallbackFile;
        synchronized (file) {
            try (FileWriter fw = new FileWriter(this.fallbackFile, true);
                 BufferedWriter bw = new BufferedWriter(fw);
                 PrintWriter out = new PrintWriter(bw);){
                out.println(line);
                out.flush();
            }
        }
    }

    @Override
    protected void closeConnection() throws Exception {
    }

    @Override
    public boolean isConnectionActive() throws Exception {
        return true;
    }

    @Override
    protected void clean() throws Exception {
    }
}

