/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.store;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.gcube.contentmanager.storageserver.store.FolderStatusObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderStatusOperationManager {
    Logger logger = LoggerFactory.getLogger(FolderStatusOperationManager.class);
    DBCollection fsCollection;

    public FolderStatusOperationManager(DBCollection fsCollection) {
        this.setFsCollection(fsCollection);
    }

    public FolderStatusObject putFSRecord(String folder, long volume, int count, String lastUpdate) {
        BasicDBObject doc = new BasicDBObject("folder", folder).append("volume", volume).append("count", count).append("lastUpdate", lastUpdate);
        this.getFsCollection().insert(doc);
        return new FolderStatusObject(folder, volume, count, lastUpdate, null);
    }

    public FolderStatusObject updateFolder(FolderStatusObject fsObject, String lastOperation) {
        if (fsObject != null) {
            String currentFolder = fsObject.getFolder();
            int currentCount = fsObject.getCount();
            long currentVolume = fsObject.getVolume();
            this.logger.debug("update Folder: " + currentFolder + " with partialVolume " + fsObject.getVolume() + " and count: " + fsObject.getCount());
            FolderStatusObject oldFsr = this.getFSRecord(currentFolder);
            if (oldFsr != null) {
                this.logger.debug("this folder " + currentFolder + " is already present in the storage");
                int partialCount = oldFsr.getCount();
                int count = this.countCalculation(fsObject.getCount(), partialCount, lastOperation);
                fsObject.setCount(count);
                long partialVolume = oldFsr.getVolume();
                long volume = this.volumeCalculation(fsObject.getVolume(), partialVolume, lastOperation);
                fsObject.setVolume(volume);
                BasicDBObject query = new BasicDBObject("folder", fsObject.getFolder());
                DBObject documentBuilder = BasicDBObjectBuilder.start().add("volume", volume).add("count", count).add("lastUpdate", fsObject.getLastUpdate()).get();
                this.getFsCollection().update(query, new BasicDBObject("$set", documentBuilder), true, false);
            } else {
                this.logger.debug("folder " + currentFolder + " not present yet");
                this.putFSRecord(fsObject.getFolder(), currentVolume, currentCount, fsObject.getLastUpdate());
            }
            String parentDir = currentFolder.substring(0, currentFolder.lastIndexOf("/"));
            this.logger.debug("recursive update from parent folder: " + parentDir);
            FolderStatusObject parentObject = new FolderStatusObject(parentDir, currentVolume, 1, fsObject.getLastUpdate(), fsObject.getOriginalFolder());
            if (parentDir != null && parentDir.contains("/")) {
                parentObject = this.updateFolder(parentObject, lastOperation);
            }
            return fsObject;
        }
        this.logger.error("invalid invocation update method: record is null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderStatusObject getFSRecord(String folder) {
        BasicDBObject query = new BasicDBObject("folder", folder);
        DBObject obj = null;
        try (DBCursor cursor = this.getFsCollection().find(query);){
            if (cursor.hasNext()) {
                obj = cursor.next();
            }
        }
        if (obj != null) {
            String currentFolder = null;
            if (obj.containsField("folder")) {
                currentFolder = (String)obj.get("folder");
            } else {
                this.logger.error("incomplete record found. folder field is missing");
            }
            long vol = 0L;
            if (obj.containsField("volume")) {
                vol = (Long)obj.get("volume");
            } else {
                this.logger.error("incomplete record found. volume field is missing");
            }
            int count = 0;
            if (obj.containsField("count")) {
                count = (Integer)obj.get("count");
            } else {
                this.logger.error("incomplete record found. count field is missing");
            }
            String lastUpdate = null;
            if (obj.containsField("lastUpdate")) {
                lastUpdate = (String)obj.get("lastUpdate");
            } else {
                this.logger.error("incomplete record found. lastUpdate field is missing");
            }
            String originalFolder = null;
            if (obj.containsField("from")) {
                originalFolder = (String)obj.get("from");
            } else {
                this.logger.debug(" originalFolder field is missing. This is correct if this isn't a move operation");
            }
            String id = (String)obj.get("id");
            return new FolderStatusObject(id, currentFolder, vol, count, lastUpdate, originalFolder, obj);
        }
        return null;
    }

    private long volumeCalculation(long currentVolume, long partialVolume, String operation) {
        this.logger.debug("folder accounting: operation " + operation + " total Volume " + partialVolume + " current volume " + currentVolume);
        if (operation.equalsIgnoreCase("UPLOAD") || operation.equalsIgnoreCase("COPY") || operation.equalsIgnoreCase("SOFT_COPY")) {
            partialVolume += currentVolume;
        } else if (operation.equalsIgnoreCase("DELETE")) {
            partialVolume -= currentVolume;
        }
        this.logger.debug("new volume " + partialVolume);
        return partialVolume;
    }

    private int countCalculation(int currentCount, int partialCount, String operation) {
        this.logger.debug("folder accounting operation " + operation + " partial count " + partialCount + " current count" + currentCount);
        if (operation.equalsIgnoreCase("UPLOAD") || operation.equalsIgnoreCase("COPY") || operation.equalsIgnoreCase("SOFT_COPY")) {
            partialCount += currentCount;
        } else if (operation.equalsIgnoreCase("DELETE")) {
            partialCount -= currentCount;
        }
        this.logger.debug("new count: " + partialCount);
        return partialCount;
    }

    public DBCollection getFsCollection() {
        return this.fsCollection;
    }

    public void setFsCollection(DBCollection fsCollection) {
        this.fsCollection = fsCollection;
    }
}

