/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.query.ConjunctionQuery;
import com.couchbase.client.java.search.query.SearchQuery;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class BooleanQuery
extends SearchQuery {
    private final ConjunctionQuery must;
    private final ConjunctionQuery mustNot;
    private final ConjunctionQuery should;

    protected BooleanQuery(Builder builder) {
        super(builder);
        this.must = builder.must;
        this.mustNot = builder.mustNot;
        this.should = builder.should;
    }

    public static Builder on(String index) {
        return new Builder(index);
    }

    public ConjunctionQuery must() {
        return this.must;
    }

    public ConjunctionQuery mustNot() {
        return this.mustNot;
    }

    public ConjunctionQuery should() {
        return this.should;
    }

    @Override
    public JsonObject queryJson() {
        JsonObject json = JsonObject.create();
        if (this.must != null) {
            json.put("must", this.must.queryJson());
        }
        if (this.mustNot != null) {
            json.put("mustNot", this.mustNot.queryJson());
        }
        if (this.should != null) {
            json.put("should", this.should.queryJson());
        }
        return json;
    }

    public static class Builder
    extends SearchQuery.Builder {
        private ConjunctionQuery must;
        private ConjunctionQuery mustNot;
        private ConjunctionQuery should;

        protected Builder(String index) {
            super(index);
        }

        @Override
        public BooleanQuery build() {
            return new BooleanQuery(this);
        }

        public Builder must(ConjunctionQuery must) {
            this.must = must;
            return this;
        }

        public Builder must(SearchQuery ... must) {
            this.must = ConjunctionQuery.on(this.index).conjuncts(must).build();
            return this;
        }

        public Builder mustNot(ConjunctionQuery mustNot) {
            this.mustNot = mustNot;
            return this;
        }

        public Builder mustNot(SearchQuery ... mustNot) {
            this.mustNot = ConjunctionQuery.on(this.index).conjuncts(mustNot).build();
            return this;
        }

        public Builder should(ConjunctionQuery should) {
            this.should = should;
            return this;
        }

        public Builder should(SearchQuery ... should) {
            this.should = ConjunctionQuery.on(this.index).conjuncts(should).build();
            return this;
        }
    }
}

