/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.refresher.AbstractRefresher;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.Buffers;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public class CarrierRefresher
extends AbstractRefresher {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CarrierRefresher.class);
    private final Set<String> subscriptions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final CoreEnvironment environment;

    public CarrierRefresher(CoreEnvironment environment, ClusterFacade cluster) {
        super(cluster);
        this.environment = environment;
        Observable.interval(10L, TimeUnit.SECONDS, environment.scheduler()).subscribe(new Action1<Long>(){

            @Override
            public void call(Long aLong) {
                CarrierRefresher.this.provider().signalOutdated();
            }
        });
    }

    @Override
    public Observable<Boolean> shutdown() {
        return Observable.just(true);
    }

    @Override
    public void markTainted(BucketConfig config) {
        final String bucketName = config.name();
        if (this.subscriptions.contains(bucketName)) {
            return;
        }
        LOGGER.debug("Config for bucket \"" + bucketName + "\" marked as tainted, starting polling.");
        this.subscriptions.add(bucketName);
        Observable<Long> pollSequence = Observable.interval(1L, TimeUnit.SECONDS).takeWhile(new Func1<Long, Boolean>(){

            @Override
            public Boolean call(Long aLong) {
                return CarrierRefresher.this.subscriptions.contains(bucketName);
            }
        });
        Observable<String> refreshSequence = null;
        ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>(config.nodes());
        Collections.shuffle(nodeInfos);
        for (final NodeInfo nodeInfo : nodeInfos) {
            if (!CarrierRefresher.isValidCarrierNode(this.environment.sslEnabled(), nodeInfo)) continue;
            if (refreshSequence == null) {
                refreshSequence = pollSequence.flatMap(new Func1<Long, Observable<String>>(){

                    @Override
                    public Observable<String> call(Long aLong) {
                        return CarrierRefresher.this.refreshAgainstNode(bucketName, nodeInfo.hostname());
                    }
                });
                continue;
            }
            refreshSequence = refreshSequence.onErrorResumeNext(this.refreshAgainstNode(bucketName, nodeInfo.hostname()));
        }
        if (refreshSequence == null) {
            LOGGER.debug("Cannot poll bucket, because node list contains no nodes.");
            return;
        }
        refreshSequence.subscribe(new Subscriber<String>(){

            @Override
            public void onCompleted() {
                LOGGER.debug("Completed polling for bucket \"{}\".", (Object)bucketName);
            }

            @Override
            public void onError(Throwable e) {
                LOGGER.debug("Error while polling bucket config, ignoring.", e);
            }

            @Override
            public void onNext(String rawConfig) {
                if (rawConfig.startsWith("{")) {
                    CarrierRefresher.this.provider().proposeBucketConfig(bucketName, rawConfig);
                }
            }
        });
    }

    @Override
    public void markUntainted(BucketConfig config) {
        if (this.subscriptions.contains(config.name())) {
            LOGGER.debug("Config for bucket \"" + config.name() + "\" marked as untainted, stopping polling.");
            this.subscriptions.remove(config.name());
        }
    }

    @Override
    public void refresh(ClusterConfig config) {
        Observable.from(config.bucketConfigs().values()).observeOn(this.environment.scheduler()).filter(new Func1<BucketConfig, Boolean>(){

            @Override
            public Boolean call(BucketConfig config) {
                return CarrierRefresher.this.registrations().containsKey(config.name());
            }
        }).subscribe(new Action1<BucketConfig>(){

            @Override
            public void call(final BucketConfig config) {
                final String bucketName = config.name();
                Observable<String> refreshSequence = null;
                ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>(config.nodes());
                Collections.shuffle(nodeInfos);
                for (NodeInfo nodeInfo : nodeInfos) {
                    if (!CarrierRefresher.isValidCarrierNode(CarrierRefresher.this.environment.sslEnabled(), nodeInfo)) continue;
                    if (refreshSequence == null) {
                        refreshSequence = CarrierRefresher.this.refreshAgainstNode(bucketName, nodeInfo.hostname());
                        continue;
                    }
                    refreshSequence = refreshSequence.onErrorResumeNext(CarrierRefresher.this.refreshAgainstNode(bucketName, nodeInfo.hostname()));
                }
                if (refreshSequence == null) {
                    LOGGER.debug("No node registered in the current configuration, skipping to refresh.");
                    return;
                }
                refreshSequence.subscribe(new Subscriber<String>(){

                    @Override
                    public void onCompleted() {
                        LOGGER.debug("Completed refreshing config for bucket \"{}\"", (Object)bucketName);
                    }

                    @Override
                    public void onError(Throwable e) {
                        LOGGER.debug("Error while refreshing bucket config, ignoring.", e);
                    }

                    @Override
                    public void onNext(String rawConfig) {
                        if (rawConfig.startsWith("{")) {
                            CarrierRefresher.this.provider().proposeBucketConfig(config.name(), rawConfig);
                        }
                    }
                });
            }
        });
    }

    private static boolean isValidCarrierNode(boolean sslEnabled, NodeInfo nodeInfo) {
        if (sslEnabled && nodeInfo.sslServices().containsKey((Object)ServiceType.BINARY)) {
            return true;
        }
        return nodeInfo.services().containsKey((Object)ServiceType.BINARY);
    }

    private Observable<String> refreshAgainstNode(final String bucketName, final InetAddress hostname) {
        return Buffers.wrapColdWithAutoRelease(Observable.defer(new Func0<Observable<GetBucketConfigResponse>>(){

            @Override
            public Observable<GetBucketConfigResponse> call() {
                return CarrierRefresher.this.cluster().send(new GetBucketConfigRequest(bucketName, hostname));
            }
        })).doOnNext(new Action1<GetBucketConfigResponse>(){

            @Override
            public void call(GetBucketConfigResponse response) {
                if (!response.status().isSuccess()) {
                    if (response.content() != null && response.content().refCnt() > 0) {
                        response.content().release();
                    }
                    throw new ConfigurationException("Could not fetch config from node: " + response);
                }
            }
        }).map(new Func1<GetBucketConfigResponse, String>(){

            @Override
            public String call(GetBucketConfigResponse response) {
                String raw = response.content().toString(CharsetUtil.UTF_8).trim();
                if (response.content().refCnt() > 0) {
                    response.content().release();
                }
                return raw.replace("$HOST", response.hostname().getHostName());
            }
        }).doOnError(new Action1<Throwable>(){

            @Override
            public void call(Throwable ex) {
                LOGGER.debug("Could not fetch config from bucket \"" + bucketName + "\" against \"" + hostname + "\".", ex);
            }
        });
    }
}

