/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.data;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.bson.types.BSONTimestamp;
import org.gcube.contentmanager.storageserver.data.CubbyHole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadingMongoOplog
extends Thread {
    static final Logger logger = LoggerFactory.getLogger(ReadingMongoOplog.class);
    public static String DBNAME = "remotefs";
    private ServerAddress[] server;
    private Mongo mongoClient;
    private DB local;
    private DBCollection oplog;
    private CubbyHole c1;
    private CubbyHole c2;
    private String user;
    private String password;
    private int number;
    private List<String> srvs;

    public ReadingMongoOplog(List<String> srvs, CubbyHole c1, CubbyHole c2, int numberT) {
        this.c1 = c1;
        this.c2 = c2;
        this.number = numberT;
        this.srvs = srvs;
        this.setupServerAddress(srvs);
        this.initBackend();
    }

    public ReadingMongoOplog(List<String> srvs, String user, String password, CubbyHole c1, CubbyHole c2, int numberT) {
        this.c1 = c1;
        this.c2 = c2;
        this.number = numberT;
        this.user = user;
        this.password = password;
        this.setupServerAddress(srvs);
        this.initBackend();
    }

    @Override
    public void run() {
        DBCursor lastCursor = this.oplog.find().sort(new BasicDBObject("$natural", (Object)-1)).limit(1);
        if (!lastCursor.hasNext()) {
            logger.error("no oplog!");
            return;
        }
        DBObject last = lastCursor.next();
        BSONTimestamp ts = (BSONTimestamp)last.get("ts");
        while (true) {
            logger.debug("starting at ts: " + ts);
            DBCursor cursor = this.oplog.find(new BasicDBObject("ts", new BasicDBObject("$gt", ts)));
            cursor.addOption(2);
            cursor.addOption(32);
            while (cursor.hasNext()) {
                DBObject x = cursor.next();
                logger.debug("oplog current object: " + x);
                ts = (BSONTimestamp)x.get("ts");
                String ns = (String)x.get("ns");
                if (x.get("o2") != null || ns.equalsIgnoreCase(DBNAME + ".fs.files")) {
                    if (x.containsField("o")) {
                        this.c1.put(x);
                        if (this.c2 != null) {
                            this.c2.put(x);
                        }
                        logger.debug("Producer #" + this.number + " put: " + x);
                        continue;
                    }
                    logger.debug("operation is not accounted");
                    continue;
                }
                logger.debug("record discarded: \t" + x);
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void initBackend() {
        this.mongoClient = new MongoClient(Arrays.asList(this.server));
        this.local = this.mongoClient.getDB("local");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean auth = false;
        if (this.user != null && this.password != null) {
            auth = this.local.authenticate(this.user.trim(), this.password.trim().toCharArray());
        }
        if (auth) {
            logger.info("mongo is in authenticate mode");
        } else {
            logger.info("mongo is not in authenticate mode");
        }
        this.oplog = this.local.getCollection("oplog.rs");
    }

    private void setupServerAddress(List<String> srvs) {
        block4: {
            try {
                if (srvs.size() > 0) {
                    this.server = new ServerAddress[srvs.size()];
                    int i = 0;
                    for (String s : srvs) {
                        this.server[i] = new ServerAddress(s);
                        ++i;
                    }
                    break block4;
                }
                logger.error("MongoDB server not set. Please set one or more servers");
                throw new RuntimeException("MongoDB server not set. Please set one or more servers");
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
    }
}

