/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.common;

import java.util.Calendar;

public class TimeRange {
    private Calendar from;
    private Calendar to;

    public TimeRange(Calendar from, Calendar to) {
        this.from = from;
        this.to = to;
        if (this.to.getTimeInMillis() == 0L) {
            this.to = Calendar.getInstance();
        }
        if (from != null && to != null && to.getTimeInMillis() < from.getTimeInMillis()) {
            Calendar aux = this.from;
            this.from = this.to;
            this.to = aux;
        }
    }

    public Calendar getFrom() {
        return this.from;
    }

    public Calendar getTo() {
        return this.to;
    }

    public boolean isClosed() {
        return this.from != null && this.to != null;
    }

    public boolean isUndefined() {
        return this.from == null && this.to == null;
    }

    public boolean endsWithin(TimeRange other) {
        if (this.to == null) {
            return false;
        }
        if (other.getFrom() == null && other.getTo() == null) {
            return false;
        }
        return this.to.after(other.getFrom()) && this.to.before(other.getTo());
    }

    public boolean startsWithin(TimeRange other) {
        if (this.to == null) {
            return false;
        }
        if (other.getFrom() == null && other.getTo() == null) {
            return false;
        }
        return this.to.after(other.getFrom()) && this.to.before(other.getTo());
    }

    public boolean isOutside(TimeRange otherRange) {
        if (this.isBefore(otherRange)) {
            return true;
        }
        return this.isAfter(otherRange);
    }

    public void constrainTo(TimeRange otherRange) {
        if (this.isBefore(otherRange)) {
            return;
        }
        if (this.isAfter(otherRange)) {
            return;
        }
        if (this.isWithin(otherRange)) {
            return;
        }
        if (this.from.before(otherRange.getFrom())) {
            this.from = otherRange.getFrom();
        }
        if (this.to.after(otherRange.getTo())) {
            this.to = otherRange.getTo();
        }
    }

    public boolean isWithin(TimeRange range) {
        if (!this.isClosed() || !range.isClosed()) {
            return false;
        }
        return this.from.after(range.getFrom()) && this.to.before(range.getTo());
    }

    public boolean isBefore(TimeRange range) {
        if (this.to == null) {
            return false;
        }
        if (range.getFrom() == null) {
            return false;
        }
        return this.to.before(range.getFrom());
    }

    public boolean isAfter(TimeRange range) {
        if (this.from == null) {
            return false;
        }
        if (range.getTo() == null) {
            return false;
        }
        return this.from.after(range.getTo());
    }

    public long getElapsed() {
        long start = this.from != null ? this.from.getTimeInMillis() : 0L;
        long end = this.to != null ? this.to.getTimeInMillis() : Calendar.getInstance().getTimeInMillis();
        return end - start;
    }
}

