/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import org.apache.activemq.usage.Usage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryUsage
extends Usage<MemoryUsage> {
    private long usage;

    public MemoryUsage() {
        this(null, null);
    }

    public MemoryUsage(MemoryUsage parent) {
        this(parent, "default");
    }

    public MemoryUsage(String name) {
        this(null, name);
    }

    public MemoryUsage(MemoryUsage parent, String name) {
        this(parent, name, 1.0f);
    }

    public MemoryUsage(MemoryUsage parent, String name, float portion) {
        super(parent, name, portion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForSpace() throws InterruptedException {
        if (this.parent != null) {
            ((MemoryUsage)this.parent).waitForSpace();
        }
        Object object = this.usageMutex;
        synchronized (object) {
            int i = 0;
            while (this.percentUsage >= 100) {
                this.usageMutex.wait();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForSpace(long timeout) throws InterruptedException {
        if (this.parent != null && !((MemoryUsage)this.parent).waitForSpace(timeout)) {
            return false;
        }
        Object object = this.usageMutex;
        synchronized (object) {
            if (this.percentUsage >= 100) {
                this.usageMutex.wait(timeout);
            }
            return this.percentUsage < 100;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFull() {
        if (this.parent != null && ((MemoryUsage)this.parent).isFull()) {
            return true;
        }
        Object object = this.usageMutex;
        synchronized (object) {
            return this.percentUsage >= 100;
        }
    }

    public void enqueueUsage(long value) throws InterruptedException {
        this.waitForSpace();
        this.increaseUsage(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseUsage(long value) {
        int percentUsage;
        if (value == 0L) {
            return;
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.usage += value;
            percentUsage = this.caclPercentUsage();
        }
        this.setPercentUsage(percentUsage);
        if (this.parent != null) {
            ((MemoryUsage)this.parent).increaseUsage(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseUsage(long value) {
        int percentUsage;
        if (value == 0L) {
            return;
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.usage -= value;
            percentUsage = this.caclPercentUsage();
        }
        this.setPercentUsage(percentUsage);
        if (this.parent != null) {
            ((MemoryUsage)this.parent).decreaseUsage(value);
        }
    }

    @Override
    protected long retrieveUsage() {
        return this.usage;
    }

    @Override
    public long getUsage() {
        return this.usage;
    }

    public void setUsage(long usage) {
        this.usage = usage;
    }
}

