/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.oidc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.oidc.AbstractOIDCToSitesAndRolesMapper;
import org.gcube.oidc.Site;
import org.gcube.oidc.SitesMapperExecption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlashSeparatedContextMapper
extends AbstractOIDCToSitesAndRolesMapper {
    protected static final Logger logger = LoggerFactory.getLogger(SlashSeparatedContextMapper.class);
    private static final String SPLIT_REGEXP = "/";
    private static final int EMPTY_TOKEN_INDEX = 0;
    private static final int ROOT_VO_TOKEN_INDEX = 1;
    private static final int VO_TOKEN_INDEX = 2;
    private static final int VRE_TOKEN_INDEX = 3;

    public SlashSeparatedContextMapper(Map<String, List<String>> resourceName2AccessRoles) {
        super(resourceName2AccessRoles);
    }

    @Override
    public Site map(String rootSite) throws SitesMapperExecption {
        ArrayList sites = new ArrayList(this.resourceName2AccessRoles.keySet());
        Collections.sort(sites);
        Site gwSitesTree = null;
        for (String site : sites) {
            logger.debug("Checking site: " + site);
            List roles = (List)this.resourceName2AccessRoles.get(site);
            logger.debug("Roles for site are: {}", (Object)roles);
            String[] siteTokens = site.split(SPLIT_REGEXP);
            logger.debug("Tokens are: {}", (Object)siteTokens.length);
            if (siteTokens.length < 2) {
                logger.debug("Skipping resource not starting with '{}'", (Object)SPLIT_REGEXP);
                continue;
            }
            String rootVO = siteTokens[1];
            logger.debug("Root VO is: {}", (Object)rootVO);
            if (!rootSite.equals(rootVO)) {
                logger.debug("Skipping evaluation of site tree not belonging to this Root VO: {}", (Object)rootVO);
                continue;
            }
            logger.debug("Site belongs to this Root VO");
            if (siteTokens.length >= 3) {
                if (gwSitesTree == null) {
                    logger.warn(rootVO + " Root VO's permissions are not set for user");
                    gwSitesTree = new Site(rootVO, null);
                }
                String vo = siteTokens[2];
                logger.debug("VO is: {}", (Object)vo);
                if (siteTokens.length == 4) {
                    if (!gwSitesTree.getChildren().containsKey(vo)) {
                        logger.warn(vo + " VO's permissions are not set for user");
                        gwSitesTree.getChildren().put(vo, new Site(vo, null));
                    }
                    String vre = siteTokens[3];
                    logger.debug("VRE is: {}", (Object)vre);
                    logger.debug("Adding leaf site: {}", (Object)vre);
                    gwSitesTree.getChildren().get(vo).getChildren().put(vre, new Site(vre, roles));
                    continue;
                }
                if (gwSitesTree.getChildren().containsKey(vo)) continue;
                logger.debug("Creating site for VO: {}", (Object)vo);
                gwSitesTree.getChildren().put(vo, new Site(vo, roles));
                continue;
            }
            if (gwSitesTree == null) {
                logger.debug("Creating site for Root VO: {}", (Object)rootVO);
                gwSitesTree = new Site(rootVO, roles);
                continue;
            }
            if (gwSitesTree.getRoles() == null) {
                logger.debug("Setting out of order roles for Root VO");
                continue;
            }
            logger.warn("Duplicated roles definition for Root VO");
        }
        return gwSitesTree;
    }
}

