/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.parse;

import com.mongodb.DBObject;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.contentmanager.storageserver.accounting.Report;
import org.gcube.contentmanager.storageserver.accounting.ReportException;
import org.gcube.contentmanager.storageserver.accounting.ReportFactory;
import org.gcube.contentmanager.storageserver.data.CubbyHole;
import org.gcube.contentmanager.storageserver.parse.utils.ValidationUtils;
import org.gcube.contentmanager.storageserver.store.MongoDB;
import org.gcube.contentmanager.storageserver.store.StorageStatusRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonParser
extends Thread {
    static final Logger logger = LoggerFactory.getLogger(JsonParser.class);
    static final int MINUTE_DECREMENT = -2;
    private CubbyHole c;
    private int number;
    private Report report;
    private String op;
    private String filename;
    private String type;
    private String name;
    private String owner;
    private String creationTime;
    private String lastAccess;
    private String lastOperation;
    private String lastUser;
    private int linkCount;
    private String delete;
    private String callerIp;
    private String user;
    private String password;
    String[] server;

    public JsonParser(String[] srvs, CubbyHole c, int number) {
        this.c = c;
        this.number = number;
        this.server = srvs;
        try {
            this.init();
        }
        catch (ReportException e) {
            throw new RuntimeException("Accounting report Exception initialization");
        }
    }

    public JsonParser(String[] srvs, String user, String password, CubbyHole c, int number) {
        this.c = c;
        this.number = number;
        this.server = srvs;
        this.user = user;
        this.password = password;
        try {
            this.init();
        }
        catch (ReportException e) {
            throw new RuntimeException("Accounting report Exception initialization");
        }
    }

    private void init() throws ReportException {
        new ReportFactory();
        this.report = ReportFactory.getReport(1);
        this.report.init();
    }

    @Override
    public void run() {
        while (true) {
            DBObject x = null;
            MongoDB mongo = null;
            try {
                x = this.c.get();
                logger.info("Consumer #" + this.number + " got: " + x);
                this.op = (String)x.get("op");
                DBObject obj = (DBObject)x.get("o");
                this.retrieveObjectFields(obj);
                long length = -1L;
                if (obj.get("length") != null) {
                    length = (Long)obj.get("length");
                }
                logger.info("[recordCheck] operation: " + this.op + " name: " + this.name + " type: " + this.type + " path: " + this.filename + " length: " + length + " owner: " + this.owner + "\n\t cretionTime: " + this.creationTime + " lastOperation " + this.lastOperation + " lastUser: " + this.lastUser + " lastAccess: " + this.lastAccess);
                if (length > 0L && (this.filename != null && this.filename.contains("/") || this.linkCount > 0)) {
                    length /= 1024L;
                    String scope = null;
                    if (this.filename != null && this.filename.contains("/")) {
                        scope = this.retrieveScopeFromRemoteFilePath(this.filename);
                    } else {
                        String pathString = (String)obj.get("onScope");
                        scope = this.retrieveScopeFromRemoteFilePath(pathString);
                    }
                    boolean validScope = ValidationUtils.validationScope(scope);
                    if (validScope) {
                        if (this.delete != null) {
                            this.lastOperation = "DELETE";
                        } else if (this.lastOperation != null && this.op != null && this.lastOperation.equalsIgnoreCase("LINK") && this.op.equalsIgnoreCase("u")) {
                            logger.info("update on link object is not accounted. Skip next ");
                            continue;
                        }
                        mongo = new MongoDB(this.server, this.user, this.password);
                        StorageStatusRecord ssr = mongo.update(this.lastUser, length, 1, this.lastOperation);
                        mongo.close();
                        this.report(this.filename, this.owner, this.creationTime, length, scope, this.lastOperation, this.callerIp, this.lastAccess, this.lastUser, String.valueOf(ssr.getVolume()), String.valueOf(ssr.getCount()));
                        logger.info(" operation accounted " + this.lastOperation);
                        logger.info("\n[accountingCall] operation: " + this.lastOperation + "\n\t name: " + this.name + "\n\t type: " + this.type + "\n\t path: " + this.filename + "\n\t length: " + length + "\n\t owner: " + this.owner + "\n\t cretionTime: " + this.creationTime + "\n\t scope: " + scope + "\n\t lastOperation " + this.lastOperation + "\n\t lastUser: " + this.lastUser + "\n\t lastAccess: " + this.lastAccess + "\n\t callerIp: " + this.callerIp);
                        continue;
                    }
                    logger.info("operation is not accounted: invalid scope: " + scope);
                    continue;
                }
                logger.info("operation is not accounted");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("ERROR Processing record: " + x + " Exception throws: " + e.getStackTrace());
                logger.info("skip to next record ");
                if (mongo == null) continue;
                mongo.close();
                continue;
            }
            break;
        }
    }

    private void retrieveObjectFields(DBObject obj) {
        this.filename = (String)obj.get("filename");
        this.type = (String)obj.get("type");
        this.name = (String)obj.get("name");
        this.owner = (String)obj.get("owner");
        this.creationTime = (String)obj.get("creationTime");
        this.lastAccess = null;
        if (obj.get("lastAccess") != null) {
            this.lastAccess = (String)obj.get("lastAccess");
        }
        this.callerIp = null;
        if (obj.get("callerIP") != null) {
            this.callerIp = (String)obj.get("callerIP");
        }
        this.lastOperation = null;
        if (obj.get("lastOperation") != null) {
            this.lastOperation = (String)obj.get("lastOperation");
        }
        this.lastUser = null;
        if (obj.get("lastUser") != null) {
            this.lastUser = (String)obj.get("lastUser");
        }
        this.linkCount = 0;
        if (obj.get("linkCount") != null) {
            this.linkCount = (Integer)obj.get("linkCount");
        }
        this.delete = null;
        if (obj.get("onDeleting") != null) {
            this.delete = (String)obj.get("onDeleting");
        }
    }

    private void report(String filename, String owner, String creationTime, long length, String scope, String operation, String callerIP, String lastAccess, String lastUser, String totVolume, String totCount) {
        RawUsageRecord sur = this.report.setGenericProperties("storage-usage", lastUser, scope, creationTime, lastAccess, owner);
        sur = this.report.setSpecificProperties(sur, operation, String.valueOf(length), filename, callerIP, "STORAGE", "1");
        this.report.send(sur);
        RawUsageRecord ssr = this.report.setGenericProperties("storage-status", lastUser, scope, creationTime, lastAccess, owner);
        sur = this.report.setSpecificProperties(ssr, operation, totVolume, filename, callerIP, "STORAGE", totCount);
        this.report.send(ssr);
    }

    private String retrieveScopeFromRemoteFilePath(String filename) {
        String[] split = filename.split("/");
        if (split.length > 0) {
            String scope = null;
            int i = 1;
            if (split[1].equals("VOLATILE")) {
                i = 2;
            }
            scope = "/" + split[i];
            ++i;
            while (!split[i].equals("home") && !split[i].equals("public")) {
                scope = String.valueOf(scope) + "/" + split[i];
                ++i;
            }
            logger.info("retieved scope: " + scope);
            return scope;
        }
        logger.error("Scope bad format: scope not retrieved from string: " + filename);
        return null;
    }
}

