/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.oaiplugin.tasks;

import java.util.TimerTask;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.oaiplugin.delegates.OAICollection;
import org.gcube.contentmanagement.contentmanager.oaiplugin.delegates.ReadManager;
import org.gcube.contentmanagement.contentmanager.oaiplugin.tasks.UpdatePair;

public class UpdateTask
extends TimerTask {
    private static GCUBELog logger = new GCUBELog(UpdateTask.class);
    OAICollection collection;

    public UpdateTask(OAICollection collection) {
        this.collection = collection;
    }

    @Override
    public void run() {
        logger.info((Object)("starting update task for collection " + this.collection.getID()));
        try {
            UpdatePair pair = ((ReadManager)this.collection.getReader()).computeUpdate();
            logger.trace((Object)("cardinality is " + pair.getCardinality() + " and lastUpdate is " + pair.getLastUpdate()));
            this.collection.setCardinality(pair.getCardinality());
            this.collection.setLastUpdate(pair.getLastUpdate());
            this.collection.store();
        }
        catch (Exception e) {
            logger.warn((Object)"error computing element number and lastUpdate", (Throwable)e);
        }
        logger.info((Object)("updates computed correctly for collection " + this.collection.getID()));
    }
}

