/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.oaiplugin.delegates;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.oaiplugin.MetadataFormat;
import org.gcube.contentmanagement.contentmanager.oaiplugin.contexts.OAIPluginContext;
import org.gcube.contentmanagement.contentmanager.oaiplugin.delegates.OAICollection;
import org.gcube.contentmanagement.contentmanager.oaiplugin.delegates.ReadManager;
import org.gcube.contentmanagement.contentmanager.oaiplugin.delegates.ReadManagerEntireRepository;
import org.gcube.contentmanagement.contentmanager.oaiplugin.delegates.ReadManagerFromListOfSets;
import org.gcube.contentmanagement.contentmanager.oaiplugin.delegates.ReadManagerSet;
import org.gcube.contentmanagement.contentmanager.oaiplugin.types.OAICreateParameters;
import org.gcube.contentmanagement.contentmanager.oaiplugin.types.OAICreateParametersBySets;
import org.gcube.contentmanagement.contentmanager.oaiplugin.types.OAICreateParametersRepository;
import org.gcube.contentmanagement.contentmanager.plugin.delegates.FactoryDelegate;
import org.w3c.dom.Element;
import uiuc.oai.OAIMetadataFormat;
import uiuc.oai.OAIMetadataFormatList;
import uiuc.oai.OAIRepository;
import uiuc.oai.OAISet;
import uiuc.oai.OAISetList;

public class OAIFactory
extends FactoryDelegate {
    GCUBELog logger = new GCUBELog(((Object)((Object)this)).getClass());

    public List<OAICollection> create(Element parameters) throws Exception {
        OAICreateParameters createParameters = OAIPluginContext.fromElement(parameters, OAICreateParameters.class);
        this.logger.trace((Object)("create class type " + createParameters.getClass().getName()));
        OAIRepository repo = new OAIRepository();
        repo.setBaseURL(createParameters.getBaseUrl());
        if (createParameters instanceof OAICreateParametersRepository) {
            try {
                return this._create((OAICreateParametersRepository)createParameters, repo);
            }
            catch (Exception e) {
                this.logger.error((Object)"error creating the collection", (Throwable)e);
                throw e;
            }
        }
        if (createParameters instanceof OAICreateParametersBySets) {
            try {
                return this._create((OAICreateParametersBySets)createParameters, repo);
            }
            catch (Exception e) {
                this.logger.error((Object)"error creating the collection", (Throwable)e);
                throw e;
            }
        }
        throw new Exception("wrong create Parameters");
    }

    private List<OAICollection> _create(OAICreateParametersBySets param, OAIRepository repository) throws Exception {
        ArrayList<OAICollection> collectionList = new ArrayList<OAICollection>();
        OAISetList setList = repository.listSets();
        MetadataFormat defaultMetadataFormat = this.retrieveDefaultMetadata(repository, param.getDefaultMdFormat());
        String repositoryName = param.getRepositoryName() == null ? repository.getRepositoryName() : param.getRepositoryName();
        this.logger.debug((Object)("the list of selected set is " + param.getSetIdentifierList()));
        while (setList.moreItems()) {
            Calendar calendar;
            OAICollection collection;
            ReadManagerSet manager;
            OAISet set = setList.getCurrentItem();
            String id = set.getSetSpec();
            String collectionId = param.getPrefix() + "-" + id;
            if (param.getSetIdentifierList() == null) {
                manager = new ReadManagerSet(collectionId, param.getBaseUrl(), defaultMetadataFormat, param.getContentXPath(), id, param.getAlternativesXpath());
                if (param.getRecordTitleXPath() != null) {
                    manager.setTitleNameXPath(param.getRecordTitleXPath());
                }
                collection = new OAICollection(collectionId, manager);
                collection.setName(repositoryName + ":" + set.getSetName());
                collection.setDescription(set.getSetDescriptionCount() > 0 ? set.getSetDescription(0).getTextContent() : "not defined");
                collection.setUser(true);
                calendar = Calendar.getInstance();
                collection.setCreationTime(calendar);
                collectionList.add(collection);
            } else if (param.getSetIdentifierList().contains(id)) {
                param.getSetIdentifierList().remove(id);
                manager = new ReadManagerSet(collectionId, param.getBaseUrl(), defaultMetadataFormat, param.getContentXPath(), id, param.getAlternativesXpath());
                if (param.getRecordTitleXPath() != null) {
                    manager.setTitleNameXPath(param.getRecordTitleXPath());
                }
                collection = new OAICollection(collectionId, manager);
                collection.setName(repositoryName + ":" + set.getSetName());
                collection.setDescription(set.getSetDescriptionCount() > 0 ? set.getSetDescription(0).getTextContent() + "(" + repository.identify() + ")" : "not defined");
                collection.setUser(true);
                calendar = Calendar.getInstance();
                collection.setCreationTime(calendar);
                collectionList.add(collection);
                if (param.getSetIdentifierList().size() == 0) break;
            }
            setList.moveNext();
        }
        return collectionList;
    }

    private List<OAICollection> _create(OAICreateParametersRepository param, OAIRepository repository) throws Exception {
        String collectionId = param.getPrefix();
        MetadataFormat defaultMetadataFormat = this.retrieveDefaultMetadata(repository, param.getDefaultMdFormat());
        ReadManager manager = param.getSetIdentifierList() == null || param.getSetIdentifierList().size() == 0 ? new ReadManagerEntireRepository(collectionId, param.getBaseUrl(), defaultMetadataFormat, param.getContentXPath(), param.getAlternativesXpath()) : new ReadManagerFromListOfSets(collectionId, param.getBaseUrl(), defaultMetadataFormat, param.getContentXPath(), param.getSetIdentifierList(), param.getAlternativesXpath());
        if (param.getRecordTitleXPath() != null) {
            manager.setTitleNameXPath(param.getRecordTitleXPath());
        }
        OAICollection collection = new OAICollection(collectionId, manager);
        collection.setName(param.getRepositoryName() == null || param.getRepositoryName().equals("") ? repository.getRepositoryName() : param.getRepositoryName());
        collection.setDescription(param.getDescription() == null || param.getDescription().equals("") ? repository.identify() : param.getDescription());
        collection.setUser(true);
        Calendar calendar = Calendar.getInstance();
        collection.setCreationTime(calendar);
        return Collections.singletonList(collection);
    }

    private MetadataFormat retrieveDefaultMetadata(OAIRepository repository, String defaultMDFormat) throws Exception {
        OAIMetadataFormatList mfList = repository.listMetadataFormats();
        this.logger.trace((Object)("defaulMetadataFormat is " + defaultMDFormat));
        while (mfList.moreItems()) {
            OAIMetadataFormat mf = mfList.getCurrentItem();
            if (mf.getMetadataPrefix().equals(defaultMDFormat)) {
                return new MetadataFormat(mf.getMetadataPrefix(), mf.getSchema());
            }
            mfList.moveNext();
        }
        throw new Exception("selected metadata prefix not found in the repository");
    }
}

