/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.oaiplugin;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.oaiplugin.delegates.ReadManager;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import uiuc.oai.OAIRecord;
import uiuc.oai.OAIRecordList;

public class GCUBEDocumentIterator
implements RemoteIterator<GDoc> {
    private static GCUBELog logger = new GCUBELog(GCUBEDocumentIterator.class);
    private ReadManager readManager;
    private OAIRecordList recordList;
    private Predicate projection;
    private GDoc doc;

    public GCUBEDocumentIterator(OAIRecordList recordList, ReadManager readManager, Predicate projection) {
        this.recordList = recordList;
        this.readManager = readManager;
        this.projection = projection;
    }

    public boolean hasNext() {
        this.doc = null;
        while (true) {
            try {
                if (!this.recordList.moreItems()) {
                    return false;
                }
                this.recordList.moveNext();
            }
            catch (Exception e) {
                logger.warn((Object)"an error occurred trying to move to the next element", (Throwable)e);
                return false;
            }
            try {
                OAIRecord record = this.recordList.getCurrentItem();
                if (record == null || record.deleted() || !record.isRecordValid() || record.getMetadata() == null) {
                    logger.trace((Object)"found a not valid record");
                    continue;
                }
                this.doc = this.readManager.extractDoc(record, this.projection);
                if (this.projection != null) {
                    try {
                        this.projection.prune((Node)this.doc);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error matching the document", (Throwable)e);
                        continue;
                    }
                }
                return true;
            }
            catch (Exception e) {
                logger.warn((Object)"an error occurred trying to retrieve a record (moving to the next element)", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public GDoc next() {
        return this.doc;
    }

    public void remove() {
        this.recordList = null;
    }

    public void close() {
        this.recordList = null;
    }

    public String locator() {
        return "local";
    }
}

