/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import ucar.nc2.util.net.EasyX509TrustManager;
import ucar.nc2.util.net.HTTPException;

public class EasySSLProtocolSocketFactory
implements ProtocolSocketFactory {
    private SSLContext sslcontext = null;

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.createSocket(host, port, clientHost, clientPort, new HttpConnectionParams());
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return this.createSocket(host, port);
        }
        return ControllerThreadSocketFactory.createSocket((ProtocolSocketFactory)this, (String)host, (int)port, (InetAddress)localAddress, (int)localPort, (int)timeout);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore createKeyStore(File keystorefile, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keystore = KeyStore.getInstance("jks");
        FileInputStream is = null;
        try {
            is = new FileInputStream(keystorefile);
            keystore.load(is, password.toCharArray());
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        return keystore;
    }

    private SSLContext createSSLContext() throws HTTPException {
        try {
            KeyManager[] keymanagers = null;
            KeyStore keystore = null;
            KeyStore truststore = null;
            TrustManager[] trustmanagers = null;
            String keypassword = EasySSLProtocolSocketFactory.getpassword("key");
            String keypath = EasySSLProtocolSocketFactory.getstorepath("key");
            String trustpassword = EasySSLProtocolSocketFactory.getpassword("trust");
            String trustpath = EasySSLProtocolSocketFactory.getstorepath("trust");
            keystore = EasySSLProtocolSocketFactory.buildstore(keypath, keypassword, "key");
            if (keystore != null) {
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance("SunX509");
                kmfactory.init(keystore, keypassword.toCharArray());
                keymanagers = kmfactory.getKeyManagers();
            }
            trustmanagers = (truststore = EasySSLProtocolSocketFactory.buildstore(trustpath, trustpassword, "trust")) != null ? new TrustManager[]{new EasyX509TrustManager(truststore)} : new TrustManager[]{new EasyX509TrustManager(null)};
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(keymanagers, trustmanagers, null);
            return sslcontext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new HTTPException("Unsupported algorithm exception: " + e.getMessage());
        }
        catch (KeyStoreException e) {
            throw new HTTPException("Keystore exception: " + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            throw new HTTPException("Key management exception: " + e.getMessage());
        }
        catch (IOException e) {
            throw new HTTPException("I/O error reading keystore/truststore file: " + e.getMessage());
        }
    }

    static String getpassword(String prefix) {
        String password = System.getProperty(prefix + "storepassword");
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        return password;
    }

    static String getstorepath(String prefix) {
        String path = System.getProperty(prefix + "store");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStore buildstore(String path, String password, String prefix) throws HTTPException {
        KeyStore store;
        block7: {
            store = null;
            try {
                if (path == null || password == null) break block7;
                File storefile = new File(path);
                if (!storefile.canRead()) {
                    throw new HTTPException("Cannot read specified " + prefix + "store:" + storefile.getAbsolutePath());
                }
                store = KeyStore.getInstance("JKS");
                FileInputStream is = null;
                try {
                    is = new FileInputStream(storefile);
                    store.load(is, password.toCharArray());
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Exception e) {
                throw new HTTPException(e);
            }
        }
        return store;
    }

    private SSLContext getSSLContext() throws HTTPException {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }
}

