/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.fmrc.FmrcImpl;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.ui.CoordSysTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.DateFormatter;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class FmrcTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted messageTable;
    private BeanTableSorted obsTable;
    private BeanTableSorted ddsTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private CoordSysTable coordSysTable;

    public FmrcTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.messageTable = new BeanTableSorted(DatasetBean.class, (PreferencesExt)prefs.node("DatasetBean"), false);
        this.messageTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FmrcTable.this.ddsTable.setBeans(new ArrayList());
                FmrcTable.this.obsTable.setBeans(new ArrayList());
                DatasetBean dsb = (DatasetBean)FmrcTable.this.messageTable.getSelectedBean();
                if (dsb != null) {
                    FmrcTable.this.coordSysTable.setDataset(dsb.ds);
                }
            }
        });
        this.obsTable = new BeanTableSorted(ObsBean.class, (PreferencesExt)prefs.node("ObsBean"), false);
        this.obsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ObsBean csb = (ObsBean)FmrcTable.this.obsTable.getSelectedBean();
            }
        });
        this.ddsTable = new BeanTableSorted(DdsBean.class, (PreferencesExt)prefs.node("DdsBean"), false);
        this.ddsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DdsBean csb = (DdsBean)FmrcTable.this.ddsTable.getSelectedBean();
            }
        });
        PopupMenu varPopup = new PopupMenu(this.messageTable.getJTable(), "Options");
        varPopup.addAction("Open as NetcdfFile", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)FmrcTable.this.messageTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                FmrcTable.this.firePropertyChange("openNetcdfFile", null, dsb.ds);
            }
        });
        varPopup.addAction("Check CoordSystems", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)FmrcTable.this.messageTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                FmrcTable.this.firePropertyChange("openCoordSystems", null, dsb.ds);
            }
        });
        varPopup.addAction("Open as GridDataset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)FmrcTable.this.messageTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                FmrcTable.this.firePropertyChange("openGridDataset", null, dsb.ds);
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.coordSysTable = new CoordSysTable((PreferencesExt)prefs.node("CoordSys"));
        this.split = new JSplitPane(0, false, this.messageTable, this.coordSysTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.messageTable.saveState(false);
        this.coordSysTable.save();
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setFmrc(FmrcImpl fmrc) throws IOException {
        ArrayList<DatasetBean> beanList = new ArrayList<DatasetBean>();
        DateFormatter df = new DateFormatter();
        beanList.add(new DatasetBean("Fmrc2d", fmrc.getFmrcDataset()));
        beanList.add(new DatasetBean("best", fmrc.getBestTimeSeries()));
        for (Date runDate : fmrc.getRunDates()) {
            beanList.add(new DatasetBean("runDate " + df.toDateTimeString(runDate), fmrc.getRunTimeDataset(runDate)));
        }
        for (Date forecastDate : fmrc.getForecastDates()) {
            beanList.add(new DatasetBean("forecast " + df.toDateTimeString(forecastDate), fmrc.getForecastTimeDataset(forecastDate)));
        }
        for (Double offset : fmrc.getForecastOffsets()) {
            beanList.add(new DatasetBean("offset " + offset, fmrc.getForecastOffsetDataset(offset)));
        }
        this.messageTable.setBeans(beanList);
        this.obsTable.setBeans(new ArrayList());
        this.ddsTable.setBeans(new ArrayList());
    }

    public class ObsBean {
        double lat = Double.NaN;
        double lon = Double.NaN;
        double alt = Double.NaN;
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int sec = -1;
        Date time;
        int wmo_block = -1;
        int wmo_id = -1;
        String stn = null;

        public ObsBean() {
        }

        public ObsBean(Structure obs, StructureData sdata) {
            String val;
            Attribute att;
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-5-1") && Double.isNaN(this.lat)) {
                    this.lat = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-6-1") && Double.isNaN(this.lon)) {
                    this.lon = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-7-30") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-1") && this.year < 0) {
                    this.year = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-2") && this.month < 0) {
                    this.month = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-3") && this.day < 0) {
                    this.day = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-4") && this.hour < 0) {
                    this.hour = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-5") && this.minute < 0) {
                    this.minute = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-6") && this.sec < 0) {
                    this.sec = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-1-1") && this.wmo_block < 0) {
                    this.wmo_block = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-1-2") && this.wmo_id < 0) {
                    this.wmo_id = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (this.stn != null || !val.equals("0-1-7") && !val.equals("0-1-194") && !val.equals("0-1-11") && !val.equals("0-1-18")) continue;
                if (v.getDataType().isString()) {
                    this.stn = sdata.getScalarString(v.getShortName());
                    continue;
                }
                this.stn = Integer.toString(sdata.convertScalarInt(v.getShortName()));
            }
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-5-2") && Double.isNaN(this.lat)) {
                    this.lat = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-6-2") && Double.isNaN(this.lon)) {
                    this.lon = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-7-1") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (!val.equals("0-4-7") || this.sec >= 0) continue;
                this.sec = sdata.convertScalarInt(v.getShortName());
            }
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-7-10") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (!val.equals("0-7-2") || !Double.isNaN(this.alt)) continue;
                this.alt = sdata.convertScalarDouble(v.getShortName());
            }
        }

        public double getLat() {
            return this.lat;
        }

        public double getLon() {
            return this.lon;
        }

        public double getHeight() {
            return this.alt;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public int getSec() {
            return this.sec;
        }

        public String getWmoId() {
            return this.wmo_block + "/" + this.wmo_id;
        }

        public String getStation() {
            return this.stn;
        }
    }

    public class DdsBean {
        DataDescriptor dds;
        int seq;

        public DdsBean() {
        }

        public DdsBean(DataDescriptor dds, int seq) {
            this.dds = dds;
            this.seq = seq;
        }

        public String getFxy() {
            return this.dds.getFxyName();
        }

        public String getName() {
            return this.dds.getName();
        }

        public String getUnits() {
            return this.dds.getUnits();
        }

        public int getBitWidth() {
            return this.dds.getBitWidth();
        }

        public int getScale() {
            return this.dds.getScale();
        }

        public int getReference() {
            return this.dds.getRefVal();
        }

        public int getSeq() {
            return this.seq;
        }

        public String getLocal() {
            return this.dds.isLocal() ? "true" : "false";
        }
    }

    public class DatasetBean {
        String name;
        NetcdfDataset ds;

        public DatasetBean() {
        }

        public DatasetBean(String name, NetcdfDataset ds) {
            this.ds = ds;
            this.name = name;
        }

        public String getLocation() throws IOException {
            return this.ds.getLocation();
        }

        public String getName() {
            return this.name;
        }
    }
}

