/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.gis.shapefile;

import java.io.DataInputStream;
import java.io.IOException;
import ucar.nc2.ui.gis.shapefile.DbaseFieldDesc;
import ucar.nc2.ui.gis.shapefile.Swap;

public class DbaseData {
    DbaseFieldDesc desc;
    int nrec;
    public static final int TYPE_CHAR = 0;
    public static final int TYPE_NUMERIC = 1;
    public static final int TYPE_BOOLEAN = 2;
    String[] character;
    double[] numeric;
    boolean[] logical;
    byte[] field;
    int type;

    DbaseData(DbaseFieldDesc desc, int nrec) {
        this.desc = desc;
        this.nrec = nrec;
        this.field = new byte[desc.FieldLength];
        switch (desc.Type) {
            case 67: 
            case 68: {
                this.character = new String[nrec];
                this.type = 0;
                break;
            }
            case 70: 
            case 78: {
                this.numeric = new double[nrec];
                this.type = 1;
                break;
            }
            case 76: {
                this.logical = new boolean[nrec];
                this.type = 2;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    int readRowN(DataInputStream ds, int n) {
        if (n > this.nrec) {
            return -1;
        }
        try {
            ds.readFully(this.field, 0, this.desc.FieldLength);
        }
        catch (IOException e) {
            return -1;
        }
        switch (this.desc.Type) {
            case 67: 
            case 68: {
                this.character[n] = new String(this.field);
                break;
            }
            case 78: {
                this.numeric[n] = Double.valueOf(new String(this.field));
                break;
            }
            case 70: {
                if (this.desc.FieldLength == 4) {
                    this.numeric[n] = Swap.swapFloat(this.field, 0);
                    break;
                }
                this.numeric[n] = Swap.swapDouble(this.field, 0);
                break;
            }
            case 76: {
                switch (this.field[0]) {
                    case 84: 
                    case 89: 
                    case 116: 
                    case 121: {
                        this.logical[n] = true;
                        break;
                    }
                    default: {
                        this.logical[n] = false;
                    }
                }
            }
            default: {
                return -1;
            }
        }
        return 0;
    }

    public double[] getDoubles() {
        return this.numeric;
    }

    public double getDouble(int i) {
        return this.numeric[i];
    }

    public boolean[] getBooleans() {
        return this.logical;
    }

    public boolean getBoolean(int i) {
        return this.logical[i];
    }

    public String[] getStrings() {
        return this.character;
    }

    public String getString(int i) {
        return this.character[i];
    }

    public Object getData(int i) {
        switch (this.type) {
            case 0: {
                return this.character[i];
            }
            case 1: {
                return new Double(this.numeric[i]);
            }
            case 2: {
                return new Boolean(this.logical[i]);
            }
        }
        return null;
    }

    public int getNumRec() {
        return this.nrec;
    }
}

