/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubemodellibrary.elements;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseInnerElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;

@XmlRootElement
public class GCubePart
extends BaseInnerElement {
    @XmlElement(name="order")
    private int order;
    @XmlTransient
    GCubePart previous;

    public GCubePart() {
    }

    public GCubePart(String id) {
        super(id);
    }

    public int order() {
        return this.order;
    }

    public void setOrder(int o) throws IllegalArgumentException, IllegalStateException {
        if (this.document() == null) {
            throw new IllegalStateException("cannot set order on a part that is not associated with a document, such as " + this);
        }
        this.order = o;
        try {
            this.findPart();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void postBinding(GCubeDocument d) throws IllegalStateException, Exception {
        super.postBinding(d);
        this.findPart();
    }

    private void findPart() throws IllegalStateException {
        if (this.order() > 1) {
            for (GCubePart p : this.document().parts()) {
                if (p.order() == this.order) {
                    throw new IllegalStateException("part order clashes with " + p);
                }
                if (p.order() != this.order() - 1) continue;
                this.previous = p;
                return;
            }
            throw new IllegalArgumentException("no part in order " + (this.order() - 1));
        }
    }

    public GCubePart previous() {
        return this.previous;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(", order=");
        builder.append(this.order);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.order;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GCubePart)) {
            return false;
        }
        GCubePart other = (GCubePart)obj;
        return this.order == other.order;
    }
}

