/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubemodellibrary.elements;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.axis.encoding.Base64;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.gcubemodellibrary.elements.Conversions;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElementProperty;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol.sms.Handler;

public abstract class BaseElement
implements GCubeElement {
    private GCUBELog logger = new GCUBELog((Object)this);
    @XmlAttribute(name="id", namespace="http://gcube-system.org/namespaces/contentmanagement/gdoc")
    private String id;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="type")
    private String type;
    @XmlElement(name="creationTime")
    private Calendar creationTime;
    @XmlElement(name="lastUpdateTime")
    private Calendar lastUpdateTime;
    @XmlElement(name="mimeType")
    private String mimeType;
    @XmlElement(name="url")
    private URI bytestreamURI;
    @XmlElement(name="bytestream")
    private String content;
    @XmlElement(name="length")
    private Long length;
    @XmlElement(name="schemaURI")
    private URI schemaURI;
    @XmlElement(name="language")
    private String language;
    @XmlElement(name="schemaName")
    private String schemaName;
    @XmlElement(name="property")
    private List<GCubeElementProperty> properties = new ArrayList<GCubeElementProperty>();

    BaseElement() {
    }

    BaseElement(String elementID) {
        this.id = elementID;
    }

    public boolean isNew() {
        return this.id() == null;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Calendar creationTime() {
        return this.creationTime;
    }

    @Override
    public Calendar lastUpdate() {
        return this.lastUpdateTime;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    @Override
    public String type() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    public void setMimeType(String type) throws IllegalArgumentException {
        this.mimeType = type;
    }

    @Override
    public URI bytestreamURI() {
        return this.bytestreamURI;
    }

    public void setBytestreamURI(URI uri) {
        this.bytestreamURI = uri;
    }

    private void detectMimeType() {
        try {
            MimeType m = MimeUtil.getMostSpecificMimeType((Collection)MimeUtil.getMimeTypes((byte[])this.bytestream()));
            this.mimeType = m.toString();
        }
        catch (MimeException me) {
            this.mimeType = null;
        }
    }

    @Override
    public InputStream resolveBytestream() throws IOException {
        URI uri = this.bytestreamURI();
        if (uri != null) {
            this.logger.trace((Object)("resolving " + uri));
            if (uri.getScheme().equals("sms")) {
                URL url = new URL(null, uri.toString(), (URLStreamHandler)new Handler());
                return url.openStream();
            }
            return uri.toURL().openStream();
        }
        byte[] stream = this.bytestream();
        if (stream != null) {
            return new ByteArrayInputStream(stream);
        }
        return null;
    }

    @Override
    public byte[] bytestream() {
        return this.content == null ? null : Base64.decode((String)this.content);
    }

    public void setBytestream(InputStream stream) throws IOException {
        if (stream == null) {
            this.content = null;
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)stream, (OutputStream)bos);
            this.setBytestream(bos.toByteArray());
            try {
                bos.close();
                stream.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"could not close temporary bytestream ", (Throwable)e);
            }
        }
    }

    public void setBytestream(Reader stream) throws IOException {
        if (stream == null) {
            this.content = null;
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((Reader)stream, (OutputStream)bos, (String)"UTF8");
            this.setBytestream(bos.toByteArray());
            try {
                bos.close();
                stream.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"could not close streams ", (Throwable)e);
            }
        }
    }

    public void setBytestream(byte[] bytes) {
        if (bytes == null) {
            this.content = null;
        } else {
            this.content = Base64.encode((byte[])bytes);
            this.length = bytes.length;
            if (this.mimeType() == null) {
                this.detectMimeType();
            }
        }
    }

    @Override
    public Long length() {
        return this.length;
    }

    public void setLenght(Long length) {
        this.length = length;
    }

    @Override
    public String language() {
        return this.language;
    }

    public void setLanguage(Locale locale) {
        this.language = locale == null ? null : locale.getLanguage();
    }

    @Override
    public URI schemaURI() {
        return this.schemaURI;
    }

    public void setSchemaURI(URI uri) {
        this.schemaURI = uri;
    }

    @Override
    public String schemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    @Override
    public Map<String, GCubeElementProperty> properties() {
        LinkedHashMap<String, GCubeElementProperty> map = new LinkedHashMap<String, GCubeElementProperty>();
        for (GCubeElementProperty p : this.properties) {
            map.put(p.key(), p);
        }
        return map;
    }

    @Override
    public GCubeElementProperty property(String key) {
        for (GCubeElementProperty p : this.properties) {
            if (!p.key().equals(key)) continue;
            return p;
        }
        return null;
    }

    public GCubeElementProperty addProperty(GCubeElementProperty property) {
        GCubeElementProperty old = this.removeProperty(property.key());
        this.properties.add(property);
        return old;
    }

    public GCubeElementProperty removeProperty(String key) {
        GCubeElementProperty old = null;
        for (GCubeElementProperty p : this.properties) {
            if (!p.key().equals(key)) continue;
            old = p;
            break;
        }
        this.properties.remove(old);
        return old;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[" + this.getClass().getSimpleName() + "] id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", creationTime=");
        builder.append(Conversions.calendarToString(this.creationTime));
        builder.append(", lastUpdateTime=");
        builder.append(Conversions.calendarToString(this.lastUpdateTime));
        builder.append(", mimeType=");
        builder.append(this.mimeType);
        builder.append(", length=");
        builder.append(this.length);
        builder.append(", bytestream=");
        if (this.content != null) {
            builder.append(this.content.length() > 100 ? this.content.substring(0, 99) + "...(and other " + this.content.length() + " chars)" : this.content);
        } else {
            builder.append("null");
        }
        builder.append(", bytestreamURI=");
        builder.append(this.bytestreamURI);
        builder.append(", language=");
        builder.append(this.language);
        builder.append(", schemaURI=");
        builder.append(this.schemaURI);
        builder.append(", schemaName=");
        builder.append(this.schemaName);
        for (GCubeElementProperty p : this.properties) {
            builder.append(", property=" + p.toString());
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.bytestreamURI == null ? 0 : this.bytestreamURI.hashCode());
        result = 31 * result + (this.creationTime == null ? 0 : this.creationTime.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.lastUpdateTime == null ? 0 : this.lastUpdateTime.hashCode());
        result = 31 * result + (this.length == null ? 0 : this.length.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : ((Object)this.properties).hashCode());
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        result = 31 * result + (this.schemaURI == null ? 0 : this.schemaURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseElement)) {
            return false;
        }
        BaseElement other = (BaseElement)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.bytestreamURI == null ? other.bytestreamURI != null : !this.bytestreamURI.equals(other.bytestreamURI)) {
            return false;
        }
        if (this.creationTime == null ? other.creationTime != null : !this.creationTime.equals(other.creationTime)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.lastUpdateTime == null ? other.lastUpdateTime != null : !this.lastUpdateTime.equals(other.lastUpdateTime)) {
            return false;
        }
        if (this.length == null ? other.length != null : !this.length.equals(other.length)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !((Object)this.properties).equals(other.properties)) {
            return false;
        }
        if (this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName)) {
            return false;
        }
        return !(this.schemaURI == null ? other.schemaURI != null : !this.schemaURI.equals(other.schemaURI));
    }

    static {
        MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
    }
}

