/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.streams.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.faults.IFaultPolicy;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.filters.Filter;

public abstract class FoldingAbstractAdapter<FROM, TO, E extends Exception> {
    private RemoteIterator<FROM> inner;
    private List<TO> elements;
    private int faultCount;
    private Filter<FROM, TO> filter;
    private IFaultPolicy<? extends E> errorHandler;
    private int size;

    public FoldingAbstractAdapter(RemoteIterator<FROM> rit, Filter<FROM, TO> f, IFaultPolicy<? extends E> h, int s) {
        this.inner = rit;
        this.filter = f;
        this.errorHandler = h;
        this.size = s;
    }

    public RemoteIterator<FROM> inner() {
        return this.inner;
    }

    protected IFaultPolicy<? extends E> errorHandler() {
        return this.errorHandler;
    }

    public boolean hasNext() {
        if (this.elements != null) {
            return true;
        }
        this.elements = new ArrayList<TO>();
        int i = 0;
        while (i < this.size && this.inner.hasNext()) {
            try {
                this.elements.add(this.filter.apply(this.inner.next()));
                ++i;
            }
            catch (Exception e) {
                ++this.faultCount;
                if (this.delegateToHandler(e, this.faultCount)) continue;
                break;
            }
        }
        return !this.elements.isEmpty();
    }

    protected abstract boolean delegateToHandler(Exception var1, int var2);

    public List<TO> next() throws E {
        if (this.elements == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        List<TO> val = this.elements;
        this.elements = null;
        return val;
    }
}

