/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.io;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.AddOutcome;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.contentmanager.stubs.UpdateFailure;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.WriteManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RSIterator;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.ResultParser;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Bindings;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.Writer;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseInnerElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.Conversions;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.xml.sax.InputSource;

public class DocumentWriter
implements Writer {
    private static GCUBELog logger = new GCUBELog(DocumentWriter.class);
    private RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition("payload")})};
    private static int POOL_SIZE;
    private static ExecutorService executor;
    private WriteManagerCall call;
    private DocumentReader reader;

    DocumentWriter(WriteManagerCall c, DocumentReader r) {
        this.call = c;
        this.reader = r;
    }

    public DocumentWriter(String collID) throws IllegalStateException, Exception {
        this(collID, GCUBEScopeManager.DEFAULT.getScope());
        if (GCUBEScopeManager.DEFAULT.getScope() == null) {
            throw new IllegalStateException("current scope is not set");
        }
    }

    public DocumentWriter(String collID, GCUBEScope scope) throws Exception {
        this.call = new WriteManagerCall(collID, scope, new GCUBESecurityManager[0]);
        this.reader = new DocumentReader(collID, scope);
        logger.trace((Object)("initializing " + this.getClass().getSimpleName() + " with collection " + collID + " in scope: " + scope));
    }

    public DocumentWriter(String collID, GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        this.call = new WriteManagerCall(collID, scope, new GCUBESecurityManager[]{securityManager});
        this.reader = new DocumentReader(collID, scope, securityManager);
        logger.trace((Object)("initializing " + this.getClass().getSimpleName() + " with collection " + collID + " in scope: " + scope));
    }

    public DocumentWriter(CollectionReference reference, GCUBEScope scope) throws Exception {
        this(reference.getCollectionID(), scope);
        this.call.setEndpointReference(reference.getWriter());
        this.reader.getCall().setEndpointReference(reference.getReader());
    }

    public DocumentWriter(CollectionReference reference) throws Exception {
        this(reference.getCollectionID(), GCUBEScopeManager.DEFAULT.getScope());
        this.call.setEndpointReference(reference.getWriter());
        this.reader.getCall().setEndpointReference(reference.getReader());
    }

    public DocumentWriter(CollectionReference reference, GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        this(reference.getCollectionID(), scope, securityManager);
        this.call.setEndpointReference(reference.getWriter());
        this.reader.getCall().setEndpointReference(reference.getReader());
    }

    @Override
    public String add(GCubeDocument doc) throws IllegalArgumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        this.validateOnAdd(doc);
        GDoc tree = Conversions.toTree((GCubeDocument)doc);
        return this.call.add(tree);
    }

    @Override
    public GCubeDocument addAndSynchronize(GCubeDocument doc) throws IllegalArgumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        return this.reader.get(this.add(doc), Projections.document());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AddOutcome> add(List<GCubeDocument> elements) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        Iterator<GCubeDocument> inputIterator = elements.iterator();
        RecordWriter writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), this.defs);
        LinkedList<AddOutcome> outcomes = new LinkedList<AddOutcome>();
        try {
            while (inputIterator.hasNext()) {
                GCubeDocument document = inputIterator.next();
                this.validateOnAdd(document);
                GenericRecord record = new GenericRecord();
                record.setFields((Field[])new StringField[]{new StringField(Conversions.toXML((GCubeDocument)document))});
                writer.put((Record)record);
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                logger.error((Object)"could not close writer", (Throwable)e);
            }
        }
        URI locator = this.call.add(writer.getLocator());
        RSIterator resultIterator = new RSIterator(locator, (ResultParser)new AddOutcomeParser(), 30);
        while (resultIterator.hasNext()) {
            outcomes.add((AddOutcome)resultIterator.next());
        }
        return outcomes;
    }

    @Override
    public Future<?> add(final Iterator<GCubeDocument> documents) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        final RecordWriter writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), this.defs);
        Runnable job = new Runnable(){

            @Override
            public void run() {
                while (documents.hasNext()) {
                    GCubeDocument document = (GCubeDocument)documents.next();
                    try {
                        DocumentWriter.this.validateOnAdd(document);
                        String tree = Conversions.toXML((GCubeDocument)document);
                        GenericRecord record = new GenericRecord();
                        record.setFields(new Field[]{new StringField(tree)});
                        writer.put((Record)record, 60L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        logger.error((Object)("error when pre-processing document for addition " + document.id()), (Throwable)e);
                    }
                }
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.error((Object)"could not close writer", (Throwable)e);
                }
            }
        };
        Future<?> outcome = executor.submit(job);
        this.call.add(writer.getLocator());
        return outcome;
    }

    @Override
    public void update(GCubeDocument doc) throws IllegalArgumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        GDoc delta = this.validateOnUpdate(doc);
        this.call.update(delta);
        doc.resetChanges();
    }

    @Override
    public GCubeDocument updateAndSynchronize(GCubeDocument doc) throws IllegalArgumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        this.update(doc);
        return this.reader.get(doc.id(), Projections.document());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Throwable> update(List<GCubeDocument> elements) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        Iterator<GCubeDocument> inputIterator = elements.iterator();
        RecordWriter writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), this.defs);
        try {
            while (inputIterator.hasNext()) {
                GCubeDocument document = inputIterator.next();
                GDoc delta = this.validateOnUpdate(document);
                StringWriter w = new StringWriter();
                Bindings.toXML((GDoc)delta, (java.io.Writer)w, (boolean[])new boolean[0]);
                String tree = w.toString();
                GenericRecord record = new GenericRecord();
                record.setFields(new Field[]{new StringField(tree)});
                writer.put((Record)record, 60L, TimeUnit.SECONDS);
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                logger.error((Object)"could not close writer", (Throwable)e);
            }
        }
        URI locator = this.call.update(writer.getLocator());
        HashMap<String, Throwable> outcomes = new HashMap<String, Throwable>();
        RSIterator resultIterator = new RSIterator(locator, (ResultParser)new UpdateFailureParser(), 30);
        while (resultIterator.hasNext()) {
            UpdateFailure failure = (UpdateFailure)resultIterator.next();
            Throwable fault = null;
            try {
                fault = failure.getFault().remoteCause();
            }
            catch (Exception e) {
                fault = failure.getFault();
            }
            outcomes.put(failure.getId(), fault);
        }
        return outcomes;
    }

    @Override
    public Future<?> update(final Iterator<GCubeDocument> documents) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        final RecordWriter writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), this.defs);
        Runnable job = new Runnable(){

            @Override
            public void run() {
                while (documents.hasNext()) {
                    GCubeDocument document = (GCubeDocument)documents.next();
                    try {
                        GDoc delta = DocumentWriter.this.validateOnUpdate(document);
                        StringWriter w = new StringWriter();
                        Bindings.toXML((GDoc)delta, (java.io.Writer)w, (boolean[])new boolean[0]);
                        String tree = w.toString();
                        GenericRecord record = new GenericRecord();
                        record.setFields(new Field[]{new StringField(tree)});
                        writer.put((Record)record, 60L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        logger.error((Object)("error when pre-processing document for update " + document.id()), (Throwable)e);
                    }
                }
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.error((Object)"could not close writer", (Throwable)e);
                }
            }
        };
        Future<?> outcome = executor.submit(job);
        this.call.update(writer.getLocator());
        return outcome;
    }

    @Override
    public void delete(GCubeDocument doc) throws IllegalArgumentException, ManagerCall.DiscoveryException, GCUBEException, Exception {
        this.call.update(this.validateOnDelete(doc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Throwable> delete(List<GCubeDocument> elements) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        Iterator<GCubeDocument> inputIterator = elements.iterator();
        RecordWriter writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), this.defs);
        try {
            while (inputIterator.hasNext()) {
                GCubeDocument document = inputIterator.next();
                GDoc tree = this.validateOnDelete(document);
                StringWriter w = new StringWriter();
                Bindings.toXML((GDoc)tree, (java.io.Writer)w, (boolean[])new boolean[0]);
                GenericRecord record = new GenericRecord();
                record.setFields(new Field[]{new StringField(w.toString())});
                writer.put((Record)record, 60L, TimeUnit.SECONDS);
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                logger.error((Object)"could not close writer", (Throwable)e);
            }
        }
        URI locator = this.call.update(writer.getLocator());
        HashMap<String, Throwable> outcomes = new HashMap<String, Throwable>();
        RSIterator resultIterator = new RSIterator(locator, (ResultParser)new UpdateFailureParser(), 30);
        while (resultIterator.hasNext()) {
            UpdateFailure failure = (UpdateFailure)resultIterator.next();
            Throwable fault = null;
            try {
                fault = failure.getFault().remoteCause();
            }
            catch (Exception e) {
                fault = failure.getFault();
            }
            outcomes.put(failure.getId(), fault);
        }
        return outcomes;
    }

    @Override
    public Future<?> delete(final Iterator<GCubeDocument> documents) throws ManagerCall.DiscoveryException, GCUBEException, Exception {
        final RecordWriter writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), this.defs);
        Runnable job = new Runnable(){

            @Override
            public void run() {
                while (documents.hasNext()) {
                    GCubeDocument document = (GCubeDocument)documents.next();
                    try {
                        GDoc tree = DocumentWriter.this.validateOnDelete(document);
                        StringWriter w = new StringWriter();
                        Bindings.toXML((GDoc)tree, (java.io.Writer)w, (boolean[])new boolean[0]);
                        GenericRecord record = new GenericRecord();
                        record.setFields(new Field[]{new StringField(w.toString())});
                        writer.put((Record)record, 60L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        logger.error((Object)("error when pre-processing document for deletion " + document.id()), (Throwable)e);
                    }
                }
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.error((Object)"could not close writer", (Throwable)e);
                }
            }
        };
        Future<?> outcome = executor.submit(job);
        this.call.update(writer.getLocator());
        return outcome;
    }

    private void validateOnAdd(GCubeDocument doc) throws IllegalArgumentException {
        if (!doc.isNew()) {
            throw new IllegalArgumentException(doc.id() + " already has an identifier");
        }
        for (BaseInnerElement e : doc.elements().values()) {
            if (e.id() == null) continue;
            throw new IllegalArgumentException(e.id() + " already has an identifier");
        }
        if (doc.collectionID() == null) {
            doc.setCollectionID(this.call.getCollectionID());
        } else if (!doc.collectionID().equals(this.call.getCollectionID())) {
            throw new IllegalArgumentException(doc.id() + " is bound to a collection other than " + this.call.getCollectionID());
        }
        logger.trace((Object)("adding " + doc));
    }

    private GDoc validateOnUpdate(GCubeDocument doc) throws IllegalArgumentException, Exception {
        if (!doc.isTracked()) {
            throw new IllegalArgumentException(doc.id() + " has not been tracked for changes");
        }
        GDoc delta = doc.delta();
        if (delta == null) {
            throw new IllegalArgumentException(doc.id() + " has been tracked but no changes have been applied to it since");
        }
        logger.trace((Object)("updating " + doc.id()));
        return delta;
    }

    private GDoc validateOnDelete(GCubeDocument doc) throws IllegalArgumentException, Exception {
        if (doc.isNew()) {
            throw new IllegalArgumentException("document has no identifier and cannot be deleted");
        }
        if (doc.isTracked() && doc.delta() != null) {
            throw new IllegalArgumentException(doc.id() + " has changes not yet committed. if intended, must reset");
        }
        logger.trace((Object)("deleting " + doc.id()));
        GDoc tree = Conversions.toTree((GCubeDocument)doc);
        tree.delete();
        return tree;
    }

    @Override
    public String collectionID() {
        return this.call.getCollectionID();
    }

    static {
        if (!TCPConnectionManager.IsInitialized()) {
            try {
                ArrayList<PortRange> ports = new ArrayList<PortRange>();
                ports.add(new PortRange(3050, 3100));
                TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(InetAddress.getLocalHost().getHostName(), ports, true));
                TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
                TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
            }
            catch (Exception e) {
                logger.warn((Object)"error initializing the result set", (Throwable)e);
            }
        }
        POOL_SIZE = 5;
        executor = Executors.newFixedThreadPool(POOL_SIZE);
    }

    private static class AddOutcomeParser
    implements ResultParser<AddOutcome> {
        private AddOutcomeParser() {
        }

        public AddOutcome parse(String s) throws Exception {
            return (AddOutcome)ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(s)), AddOutcome.class);
        }
    }

    private static class UpdateFailureParser
    implements ResultParser<UpdateFailure> {
        private UpdateFailureParser() {
        }

        public UpdateFailure parse(String s) throws Exception {
            return (UpdateFailure)ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(s)), UpdateFailure.class);
        }
    }
}

