/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.io;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentCache;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;

public class SimpleLRUCache
extends LinkedHashMap<String, GCubeDocument>
implements DocumentCache {
    private static GCUBELog logger = new GCUBELog(SimpleLRUCache.class);
    public static int DEFAULT_SIZE = 50;
    private static final long serialVersionUID = 1L;
    private int size;

    public SimpleLRUCache() {
        this(DEFAULT_SIZE, 0.75f);
    }

    public SimpleLRUCache(int size) {
        this(size, 0.75f);
    }

    public SimpleLRUCache(int s, float factor) {
        super(s, factor, false);
        this.size = s;
    }

    @Override
    public GCubeDocument get(String id) {
        return (GCubeDocument)super.get(id);
    }

    @Override
    public void put(GCubeDocument doc) {
        this.put(doc.id(), doc);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, GCubeDocument> eldest) {
        if (this.size() >= this.size) {
            logger.trace((Object)("evicted document " + eldest.getKey()));
            return true;
        }
        return false;
    }
}

