/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.factsheetplugin.delegates;

import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.factsheetplugin.restinterface.Util;
import org.gcube.contentmanagement.contentmanager.factsheetplugin.restinterface.handlers.Factsheet;
import org.gcube.contentmanagement.contentmanager.factsheetplugin.types.GCUBEDocumentIterator;
import org.gcube.contentmanagement.contentmanager.plugin.delegates.ReadDelegate;
import org.gcube.contentmanagement.contentmanager.stubs.calls.exceptions.UnknownDocumentException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.InnerNode;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Nodes;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ReadManager
extends ReadDelegate {
    private static final long serialVersionUID = 552599507137702294L;
    private String domainName;
    private String contentXPath;
    private String titleXPath;
    private transient Transformer transformer;
    private static GCUBELog logger = new GCUBELog(ReadManager.class);

    public ReadManager(String domainName, String contentXpath, String titleXPath) {
        this.domainName = domainName;
        this.contentXPath = contentXpath;
        this.titleXPath = titleXPath;
    }

    private Transformer getTransformer() throws Exception {
        if (this.transformer == null) {
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        return this.transformer;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public GDoc get(String id, Predicate projection) throws UnknownDocumentException, GCUBEException, Exception {
        GDoc doc = this.extractDoc(Util.getFactsheetObject(id, this.domainName), this.domainName);
        if (projection != null) {
            projection.prune((Node)doc);
        }
        return doc;
    }

    public RemoteIterator<GDoc> get(Predicate projection) throws Exception, GCUBEException {
        return new GCUBEDocumentIterator(Util.getFactsheetsIdentifiersPerDomain(this.domainName), this, projection);
    }

    public GDoc extractDoc(Factsheet factsheet, String domainName) throws Exception {
        Edge nameEdge;
        Edge contentEdge;
        Edge lengthEdge;
        Edge mimeTypeEdge;
        GDoc doc;
        Edge lastUpdateTimeEdge;
        Edge creationTimeEdge;
        long start;
        block13: {
            NodeList nl;
            start = System.currentTimeMillis();
            Document factsheetDOM = factsheet.getLanguages().contains("en") ? Util.getFactsheetDocument(factsheet.getId(), domainName, "en") : Util.getFactsheetDocument(factsheet.getId(), domainName, factsheet.getLanguages().get(0));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList listNodes = (NodeList)xPath.evaluate("/*[local-name()='FIGISDoc']/*[local-name()='DataEntry']/*[local-name()='Created']", factsheetDOM, XPathConstants.NODESET);
            try {
                creationTimeEdge = Nodes.e((String)"creationTime", (Object)this.getDate(listNodes.item(0).getTextContent()));
                lastUpdateTimeEdge = Nodes.e((String)"lastUpdateTime", (Object)this.getDate(listNodes.item(0).getTextContent()));
            }
            catch (Exception e) {
                logger.error((Object)"cannot retrieve the CreationTime");
                creationTimeEdge = Nodes.e((String)"creationTime", (Object)Calendar.getInstance());
                lastUpdateTimeEdge = Nodes.e((String)"lastUpdateTime", (Object)Calendar.getInstance());
            }
            doc = new GDoc(factsheet.getId());
            doc.collectionID(this.getCollection().getID());
            doc.add(new Edge[]{creationTimeEdge, lastUpdateTimeEdge});
            StringWriter metadata = new StringWriter();
            this.getTransformer().transform(new DOMSource(factsheetDOM), new StreamResult(metadata));
            mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"");
            lengthEdge = Nodes.e((String)"length", (Object)0);
            contentEdge = Nodes.e((String)"url", (Object)"");
            nameEdge = Nodes.e((String)"name", (Object)factsheet.getId());
            if (this.titleXPath != null && (nl = (NodeList)(xPath = XPathFactory.newInstance().newXPath()).evaluate(this.titleXPath, factsheetDOM, XPathConstants.NODESET)).item(0) != null) {
                String title = nl.item(0).getTextContent();
                try {
                    nameEdge = Nodes.e((String)"name", (Object)title);
                }
                catch (Exception e) {
                    logger.warn((Object)("impossible to retrieve the title for doc " + factsheet.getId()));
                }
            }
            if (this.contentXPath != null) {
                try {
                    xPath = XPathFactory.newInstance().newXPath();
                    nl = (NodeList)xPath.evaluate(this.contentXPath, factsheetDOM, XPathConstants.NODESET);
                    if (nl.item(0) == null) break block13;
                    String contentUri = nl.item(0).getTextContent();
                    try {
                        mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"text/uri-list");
                    }
                    catch (Exception e) {
                        logger.warn((Object)("impossible to retrieve the mimeType for doc " + factsheet.getId()));
                    }
                    try {
                        lengthEdge = Nodes.e((String)"length", (Object)contentUri.getBytes().length);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("impossible to retrieve the content length for doc " + factsheet.getId()));
                    }
                    contentEdge = Nodes.e((String)"url", (Object)contentUri);
                }
                catch (Throwable e) {
                    logger.error((Object)("impossible to retrieve content for document " + factsheet.getId()), e);
                }
            }
        }
        doc.add(new Edge[]{mimeTypeEdge, lengthEdge, contentEdge, nameEdge});
        for (String fl : factsheet.getLanguages()) {
            String metadataUri = "http://www.fao.org/figis/ws/factsheets/domain/" + this.domainName + "/factsheet/" + factsheet.getId() + "/language/" + fl;
            doc.add(Arrays.asList(this.createMetadataEdge(metadataUri, "FiMES", "http://fimes.xsd", fl, factsheet.getId() + fl, creationTimeEdge, lastUpdateTimeEdge)));
        }
        logger.trace((Object)("time took for doc extraction is : " + (System.currentTimeMillis() - start)));
        return doc;
    }

    private Edge createMetadataEdge(String metadataUri, String prefix, String schema, String language, String identifier, Edge createTimeEdge, Edge lastUpdateTimeEdge) throws Exception {
        return Nodes.e((String)"isDescribedBy", (Node)new InnerNode(identifier, new Edge[]{Nodes.e((String)"mimeType", (Object)"text/uri-list"), Nodes.e((String)"length", (Object)metadataUri.length()), Nodes.e((String)"language", (Object)language), Nodes.e((String)"name", (Object)prefix), Nodes.e((String)"schemaURI", (Object)schema), Nodes.e((String)"url", (Object)metadataUri), createTimeEdge, lastUpdateTimeEdge}));
    }

    private Calendar getDate(String datestamp) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.parse(datestamp);
        return dateFormat.getCalendar();
    }
}

