/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.processing;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gcube.application.aquamaps.ecomodelling.generators.abstracts.AbstractGenerationAlgorithm;
import org.gcube.application.aquamaps.ecomodelling.generators.aquamapsorg.AquamapsAlgorithm;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.GenerationModel;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.RemoteHspecInputObject;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.RemoteHspecOutputObject;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.livemonitor.ResourceLoad;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.livemonitor.Resources;
import org.gcube.application.aquamaps.ecomodelling.generators.processing.RemoteGenerationManager;
import org.gcube.application.aquamaps.ecomodelling.generators.utils.DatabaseFactory;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.hibernate.SessionFactory;

public class DistributionGenerator {
    List<Object> selectedSpecies;
    List<Object> csquares;
    List<Object> speciesInfo;
    List<Object> speciesObservations;
    HashMap<String, String> currentSpeciesBoundingBoxInfo;
    String currentFAOAreas;
    String generationType;
    String currentSpeciesId;
    int csquaresNumber;
    String dynamicWriteQuery;
    String dynamicCSquareQuery;
    String dynamicHSpenQuery;
    String dynamicHSpenMinmaxQuery;
    boolean[] threadActivity;
    AbstractGenerationAlgorithm generationAlgorithm;
    GenerationModel generatorAlgorithm = GenerationModel.AQUAMAPS;
    RemoteGenerationManager remoteGenerationManager;
    boolean useDB = true;
    private boolean interruptProcessing;
    double status;
    double globalstatus;
    private ExecutorService executorService;
    boolean isRemoteGeneration;
    int processedRecordsCounter;
    long tstart;
    int numbOfProcessedSpecies;
    protected SessionFactory vreConnection;
    StringBuffer probsClause;
    StringBuffer speciesCriteria1;
    StringBuffer speciesCriteria2;
    StringBuffer speciesCriteria3;
    boolean nativegeneration = false;
    static int chunksize = 5000;
    int numberOfthreads = 16;
    String defaultDatabaseFile = "DestinationDBHibernate.cfg.xml";
    String defaultLogFile = "ALog.properties";
    String default_hspec_suitable_table = "hspec_suitable_gp2";
    String default_hcaf_table = "hcaf_d";
    String default_hspen_table = "hspen";
    String default_hspen_maxminlat = "maxminlat_hspen";
    String default_species_list = "selectedSpecies.txt";
    String default_remote_calculator = "http://node1.d.venusc.research-infrastructures.eu:5941/api/";
    String default_service_userName = "unknown";
    String default_remote_environment = "windows azure";
    HashMap<String, String> default_remote_properties;
    String default_cache_path = "./cfg/";
    String default_summaryLog = null;
    static String csquareCodeQuery = "select csquarecode,depthmean,depthmax,depthmin, sstanmean,sbtanmean,salinitymean,salinitybmean, primprodmean,iceconann,landdist,oceanarea,centerlat,centerlong,faoaream,eezall,lme from %1$s d where oceanarea>0";
    static String selectSpeciesQuery = "select depthmin,meandepth,depthprefmin,pelagic,depthprefmax,depthmax,tempmin,layer,tempprefmin,tempprefmax,tempmax,salinitymin,salinityprefmin,salinityprefmax,salinitymax,primprodmin,primprodprefmin,primprodprefmax,primprodmax,iceconmin,iceconprefmin,iceconprefmax,iceconmax,landdistyn,landdistmin,landdistprefmin,landdistprefmax,landdistmax,nmostlat,smostlat,wmostlong,emostlong,faoareas from %HSPEN% where speciesid = '%1$s';";
    static String selectAllSpeciesQuery = "select depthmin,meandepth,depthprefmin,pelagic,depthprefmax,depthmax,tempmin,layer,tempprefmin,tempprefmax,tempmax,salinitymin,salinityprefmin,salinityprefmax,salinitymax,primprodmin,primprodprefmin,primprodprefmax,primprodmax,iceconmin,iceconprefmin,iceconprefmax,iceconmax,landdistyn,landdistmin,landdistprefmin,landdistprefmax,landdistmax,nmostlat,smostlat,wmostlong,emostlong,faoareas,speciesid from %HSPEN%;";
    static String selectAllSpeciesObservationQuery = "SELECT speciesid,maxclat,minclat from %HSPEN%;";
    static String valuesTemplate = "('%1$s','%2$s','%3$s','%4$s','%5$s','%6$s','%7$s','%8$s')";
    static String insertionStatement = "insert into %TABLENAME% values %1$s;";
    static String createTableStatement = "CREATE TABLE %1$s ( speciesid character varying, csquarecode character varying, probability real, boundboxyn smallint, faoareayn smallint, faoaream integer, eezall character varying, lme integer) WITH (OIDS=FALSE ); ALTER TABLE %1$s OWNER TO %2$s;";
    static String createTableStatementPartitioned = "CREATE TABLE %1$s ( speciesid character varying, csquarecode character varying, probability real, boundboxyn smallint, faoareayn smallint, faoaream integer, eezall character varying, lme integer)  WITH (OIDS=FALSE ) TABLESPACE %3$s; ALTER TABLE %1$s OWNER TO %2$s; ";
    static String createIndexStatement = "CREATE INDEX CONCURRENTLY %1$s_idx ON %1$s USING btree (speciesid, csquarecode, faoaream, eezall, lme);";
    static String speciesListQuery = "select distinct speciesid from %1$s;";
    String dbjdbcUrl;
    String dbuserName;
    String dbpassword;
    private double remoteMultiplier;
    private double remoteShift;
    private int lastProcessedRecordsNumber;
    private long lastTime;
    HashMap<String, List<Object>> allSpeciesHspen;
    HashMap<String, List<Object>> allSpeciesObservations;

    public double getStatus() {
        if (this.isRemoteGeneration) {
            try {
                if (this.status == 100.0) {
                    return 100.0;
                }
                return this.remoteShift + this.remoteGenerationManager.retrieveCompletion() * this.remoteMultiplier;
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return this.globalstatus;
    }

    public String getSummaryComputationFile() {
        return this.default_summaryLog;
    }

    public String getSpeciesLoad() {
        String returnString = "";
        try {
            if (this.isRemoteGeneration) {
                RemoteHspecOutputObject rhoo = this.remoteGenerationManager.retrieveCompleteStatus();
                if (rhoo.metrics.throughput.size() > 1) {
                    ResourceLoad rs = new ResourceLoad(rhoo.metrics.throughput.get(0), rhoo.metrics.throughput.get(1).longValue());
                    returnString = rs.toString();
                }
            } else {
                long tk = System.currentTimeMillis();
                double activity = this.numbOfProcessedSpecies;
                ResourceLoad rs = new ResourceLoad(tk, activity);
                returnString = rs.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            long tk = System.currentTimeMillis();
            returnString = new ResourceLoad(tk, 0.0).toString();
        }
        return returnString;
    }

    public String getResourceLoad() {
        String returnString;
        block6: {
            returnString = "";
            try {
                if (this.isRemoteGeneration) {
                    try {
                        RemoteHspecOutputObject rhoo = this.remoteGenerationManager.retrieveCompleteStatus();
                        if (rhoo.metrics.throughput.size() > 1) {
                            ResourceLoad rs = new ResourceLoad(rhoo.metrics.throughput.get(0), rhoo.metrics.throughput.get(1).longValue());
                            returnString = rs.toString();
                        }
                        break block6;
                    }
                    catch (Exception e) {}
                    break block6;
                }
                long tk = System.currentTimeMillis();
                double activity = Double.valueOf(this.processedRecordsCounter - this.lastProcessedRecordsNumber) * 1000.0 / Double.valueOf(tk - this.lastTime);
                this.lastTime = tk;
                this.lastProcessedRecordsNumber = this.processedRecordsCounter;
                ResourceLoad rs = new ResourceLoad(tk, activity);
                returnString = rs.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                long tk = System.currentTimeMillis();
                returnString = new ResourceLoad(tk, 0.0).toString();
            }
        }
        this.writeSummaryLog(returnString);
        return returnString;
    }

    private void writeSummaryLog(String summaryString) {
        if (this.default_summaryLog != null && this.default_summaryLog.length() > 0) {
            FileWriter fw = null;
            try {
                fw = new FileWriter(this.default_summaryLog, true);
                fw.write(summaryString + System.getProperty("line.separator"));
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().trace("writeSummaryLog-> an error has occurred with the file ", (Throwable)e);
                try {
                    fw.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
    }

    public String getResources() {
        Resources res = new Resources();
        try {
            if (this.isRemoteGeneration) {
                try {
                    RemoteHspecOutputObject rhoo = this.remoteGenerationManager.retrieveCompleteStatus();
                    res.list = rhoo.metrics.load;
                }
                catch (Exception e) {}
            } else {
                for (int i = 0; i < this.numberOfthreads; ++i) {
                    try {
                        double value = this.threadActivity[i] ? 100.0 : 0.0;
                        res.addResource("Thread_" + (i + 1), value);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.list != null) {
            return HttpRequest.toJSon(res.list).replace("resId", "resID");
        }
        return "";
    }

    public GenerationModel getGenerationAlgorithm() {
        return this.generatorAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSelectedSpecies() {
        BufferedReader br = null;
        if (this.selectedSpecies == null) {
            try {
                br = new BufferedReader(new FileReader(this.default_species_list));
                this.selectedSpecies = new ArrayList<Object>();
                String line = br.readLine();
                while (line != null) {
                    this.selectedSpecies.add(line.trim());
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().trace("Distribution Generator - SELECTED SPECIES - FILE NOT FOUND - POPULATING FROM DB");
                this.populateSelectedSpeciesByDB();
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void populateSelectedSpeciesByDB() {
        String query = String.format(speciesListQuery, this.default_hspen_table);
        AnalysisLogger.getLogger().trace("Distribution Generator ->getting all species list from DB");
        if (this.useDB) {
            List<Object> allspecies = DatabaseFactory.executeSQLQuery(query, this.vreConnection);
            this.selectedSpecies = allspecies;
        }
    }

    public void setSelectedSpecies(ArrayList<String> selectedSpecies) {
        this.selectedSpecies = new ArrayList<Object>();
        for (String species : selectedSpecies) {
            this.selectedSpecies.add(species);
        }
    }

    private void getCsquares() {
        this.csquares = new ArrayList<Object>();
        long t0 = System.currentTimeMillis();
        if (this.useDB) {
            this.csquares = DatabaseFactory.executeSQLQuery(this.dynamicCSquareQuery, this.vreConnection);
        }
        long t1 = System.currentTimeMillis();
        AnalysisLogger.getLogger().trace("Distribution Generator-> CSQUARES QUERY - EXECUTION TIME : " + (t1 - t0));
    }

    private void getSpeciesInfo(String speciesid) {
        this.speciesInfo = null;
        this.speciesObservations = null;
        this.speciesInfo = this.allSpeciesHspen.get(speciesid);
        this.speciesObservations = this.allSpeciesObservations.get(speciesid);
        this.currentSpeciesId = speciesid;
    }

    private void getAllSpeciesInfo() {
        this.allSpeciesHspen = new HashMap();
        this.allSpeciesObservations = new HashMap();
        if (this.useDB) {
            String speciesid;
            int i;
            long t0 = System.currentTimeMillis();
            List<Object> SpeciesInfo = DatabaseFactory.executeSQLQuery(this.dynamicHSpenQuery, this.vreConnection);
            List<Object> SpeciesObservations = DatabaseFactory.executeSQLQuery(this.dynamicHSpenMinmaxQuery, this.vreConnection);
            int lenSpecies = SpeciesInfo.size();
            int lenObservations = SpeciesObservations.size();
            for (i = 0; i < lenSpecies; ++i) {
                Object[] speciesArray = (Object[])SpeciesInfo.get(i);
                speciesid = (String)speciesArray[33];
                ArrayList<Object[]> singleSpeciesInfo = new ArrayList<Object[]>();
                singleSpeciesInfo.add(speciesArray);
                this.allSpeciesHspen.put(speciesid, singleSpeciesInfo);
            }
            for (i = 0; i < lenObservations; ++i) {
                Object[] maxminArray = (Object[])SpeciesObservations.get(i);
                speciesid = (String)maxminArray[0];
                ArrayList<Object[]> maxminInfo = new ArrayList<Object[]>();
                maxminInfo.add(maxminArray);
                this.allSpeciesObservations.put(speciesid, maxminInfo);
            }
            long t1 = System.currentTimeMillis();
            AnalysisLogger.getLogger().trace("ElapsedTime for HSpen information population : " + (t1 - t0) + "ms " + " number of species :" + lenSpecies);
        }
    }

    private void initBuffers() {
        this.speciesCriteria1 = null;
        this.speciesCriteria2 = null;
        this.speciesCriteria3 = null;
        this.probsClause = null;
        this.speciesCriteria1 = new StringBuffer();
        this.speciesCriteria2 = new StringBuffer();
        this.speciesCriteria3 = new StringBuffer();
        this.probsClause = new StringBuffer();
    }

    private void insertValues(String clauses) throws Throwable {
        if (this.useDB) {
            DatabaseFactory.executeSQLUpdate(String.format(this.dynamicWriteQuery, clauses), this.vreConnection);
        }
    }

    private void deleteValues() throws Exception {
        String query = "delete from " + this.default_hspec_suitable_table;
        if (this.useDB) {
            DatabaseFactory.executeSQLUpdate(query, this.vreConnection);
        }
    }

    private void insertCriteria() {
        StringBuffer criteria = null;
        if (this.speciesCriteria1.length() > 0) {
            criteria = this.speciesCriteria1;
        } else if (this.speciesCriteria2.length() > 0) {
            criteria = this.speciesCriteria2;
        } else if (this.speciesCriteria3.length() > 0) {
            criteria = this.speciesCriteria3;
        } else if (this.probsClause.length() > 0) {
            criteria = this.probsClause;
        }
        this.bulkInsert(criteria);
    }

    private void bulkInsert(StringBuffer criteria) {
        if (criteria != null) {
            int lastcomma = criteria.length();
            if (lastcomma > 5000000) {
                AnalysisLogger.getLogger().trace("BulkInsert-> Separating criteria elementsfor insert");
                String[] subcriteria = criteria.toString().split("\\),");
                int fulllen = subcriteria.length;
                int len = fulllen / 2;
                StringBuffer subcrit = new StringBuffer();
                AnalysisLogger.getLogger().trace("BulkInsert-> First chunk : till " + len);
                for (int i = 0; i < len; ++i) {
                    subcrit.append(subcriteria[i] + "),");
                }
                int sublen = subcrit.length();
                subcrit = subcrit.replace(sublen - 1, sublen, "");
                try {
                    AnalysisLogger.getLogger().trace("BulkInsert-> Inserting values for chunk");
                    this.insertValues(subcrit.toString());
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
                AnalysisLogger.getLogger().trace("BulkInsert-> Second chunk: till " + fulllen);
                subcrit = null;
                subcrit = new StringBuffer();
                for (int i = len; i < fulllen; ++i) {
                    subcrit.append(subcriteria[i] + "),");
                }
                int restlen = subcrit.length();
                subcrit = subcrit.replace(restlen - 1, restlen, "");
                try {
                    this.insertValues(subcrit.toString());
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
                subcrit = null;
            } else if (lastcomma > 0) {
                criteria = criteria.replace(lastcomma - 1, lastcomma, "");
                try {
                    this.insertValues(criteria.toString());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void wait4Thread(int index) {
        while (this.threadActivity[index]) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void initializeThreads(int numberOfThreadsToUse) {
        this.executorService = Executors.newFixedThreadPool(numberOfThreadsToUse);
        this.threadActivity = new boolean[numberOfThreadsToUse];
        for (int j = 0; j < this.threadActivity.length; ++j) {
            this.threadActivity[j] = false;
        }
    }

    public HashMap<String, Integer> calculateBoundingBox(Object[] csquarecode) {
        HashMap<String, Integer> boundingInfo = this.generationAlgorithm.calculateBoundingBox("" + csquarecode[0], this.currentSpeciesBoundingBoxInfo.get("$pass_NS"), this.currentSpeciesBoundingBoxInfo.get("$pass_N"), this.currentSpeciesBoundingBoxInfo.get("$pass_S"), AquamapsAlgorithm.getElement(csquarecode, 12), AquamapsAlgorithm.getElement(csquarecode, 13), AquamapsAlgorithm.getElement(csquarecode, 14), this.currentSpeciesBoundingBoxInfo.get("$paramData_NMostLat"), this.currentSpeciesBoundingBoxInfo.get("$paramData_SMostLat"), this.currentSpeciesBoundingBoxInfo.get("$paramData_WMostLong"), this.currentSpeciesBoundingBoxInfo.get("$paramData_EMostLong"), this.currentFAOAreas, this.currentSpeciesBoundingBoxInfo.get("$northern_hemisphere_adjusted"), this.currentSpeciesBoundingBoxInfo.get("$southern_hemisphere_adjusted"));
        return boundingInfo;
    }

    public double calculateModelProbability(Object[] hspen, Object[] csquareinfo) {
        return this.generationAlgorithm.getSpeciesProb(hspen, csquareinfo);
    }

    void calcProb(String speciesid, int startindex) throws Exception {
        int max = Math.min(startindex + chunksize, this.csquaresNumber);
        for (int i = startindex; i < max; ++i) {
            Object[] csquarecode = (Object[])this.csquares.get(i);
            double prob = this.generationAlgorithm.getSpeciesProb((Object[])this.speciesInfo.get(0), csquarecode);
            HashMap<String, Integer> boundingInfo = this.calculateBoundingBox(csquarecode);
            if (prob >= 0.01) {
                this.probsClause.append(String.format(valuesTemplate, this.currentSpeciesId, "" + csquarecode[0], prob, boundingInfo.get("$InBox"), boundingInfo.get("$InFAO"), "" + csquarecode[14], "" + csquarecode[15], "" + csquarecode[16]) + ",");
            }
            ++this.processedRecordsCounter;
        }
    }

    void calcProbNative(String speciesid, int startindex) throws Exception {
        int max = Math.min(startindex + chunksize, this.csquaresNumber);
        for (int i = startindex; i < max; ++i) {
            Object[] csquarecode = (Object[])this.csquares.get(i);
            double prob = this.generationAlgorithm.getSpeciesProb((Object[])this.speciesInfo.get(0), csquarecode);
            HashMap<String, Integer> boundingInfo = this.calculateBoundingBox(csquarecode);
            if (prob >= 0.01) {
                Integer Inbox = boundingInfo.get("$InBox");
                Integer InFAO = boundingInfo.get("$InFAO");
                String values = String.format(valuesTemplate, this.currentSpeciesId, "" + csquarecode[0], prob, boundingInfo.get("$InBox"), boundingInfo.get("$InFAO"), "" + csquarecode[14], "" + csquarecode[15], "" + csquarecode[16]);
                if (Inbox == 1 && InFAO == 1) {
                    this.speciesCriteria1.append(values + ",");
                } else if (Inbox == 0 && InFAO == 1) {
                    this.speciesCriteria2.append(values + ",");
                } else if (Inbox == 1 && InFAO == 0) {
                    this.speciesCriteria3.append(values + ",");
                }
            }
            ++this.processedRecordsCounter;
        }
    }

    public void initDBSession(EngineConfiguration engineConf) throws Exception {
        if (engineConf != null && engineConf.getConfigPath() != null) {
            this.defaultDatabaseFile = engineConf.getConfigPath() + this.defaultDatabaseFile;
            this.dbjdbcUrl = engineConf.getDatabaseURL();
            this.dbuserName = engineConf.getDatabaseUserName();
            this.dbpassword = engineConf.getDatabasePassword();
        }
        if (this.useDB) {
            this.vreConnection = DatabaseFactory.initDBConnection(this.defaultDatabaseFile, engineConf);
        }
    }

    public void shutdownConnection() {
        this.vreConnection.close();
    }

    public DistributionGenerator(EngineConfiguration engine) throws Exception {
        if (engine != null) {
            this.useDB = engine.useDB();
            this.initDBSession(engine);
            if (engine.getConfigPath() != null) {
                this.defaultLogFile = engine.getConfigPath() + this.defaultLogFile;
                this.default_species_list = engine.getConfigPath() + this.default_species_list;
            }
            AnalysisLogger.setLogger((String)this.defaultLogFile);
            this.nativegeneration = engine.isNativeGeneration();
            if (engine.getDistributionTable() != null) {
                this.default_hspec_suitable_table = engine.getDistributionTable();
            }
            if (engine.getCachePath() != null) {
                this.default_cache_path = engine.getCachePath();
            }
            if (engine.getWriteSummaryLog().booleanValue()) {
                this.default_summaryLog = this.default_cache_path + "distributionProcessSummary_" + UUID.randomUUID() + ".log";
            }
            if (engine.getMaxminLatTable() != null) {
                this.default_hspen_maxminlat = engine.getMaxminLatTable();
            }
            this.dynamicWriteQuery = insertionStatement.replace("%TABLENAME%", this.default_hspec_suitable_table);
            this.generationType = engine.isType2050() != false ? "2050" : "";
            if (engine.getServiceUserName() != null) {
                this.default_service_userName = engine.getServiceUserName();
            }
            if (engine.getRemoteCalculator() != null) {
                this.default_remote_calculator = engine.getRemoteCalculator();
            }
            if (engine.getHcafTable() != null) {
                this.default_hcaf_table = engine.getHcafTable();
            }
            if (engine.getHspenTable() != null) {
                this.default_hspen_table = engine.getHspenTable();
            }
            if (engine.getRemoteEnvironment() != null) {
                this.default_remote_environment = engine.getRemoteEnvironment();
            }
            if (engine.getGeneralProperties() != null) {
                this.default_remote_properties = engine.getGeneralProperties();
            }
            if (engine.getNumberOfThreads() != null) {
                this.numberOfthreads = engine.getNumberOfThreads();
            }
            if (engine.getGenerator() != null) {
                this.generatorAlgorithm = engine.getGenerator();
            }
            if (engine.createTable().booleanValue()) {
                try {
                    if (this.useDB) {
                        String createPartitionTableStatement = "";
                        createPartitionTableStatement = engine.getTableStore() != null ? String.format(createTableStatementPartitioned, this.default_hspec_suitable_table, engine.getDatabaseUserName(), engine.getTableStore()) : String.format(createTableStatement, this.default_hspec_suitable_table, engine.getDatabaseUserName());
                        if (("" + (Object)((Object)this.generatorAlgorithm)).startsWith("REMOTE")) {
                            DatabaseFactory.executeSQLUpdate(createPartitionTableStatement, this.vreConnection);
                            AnalysisLogger.getLogger().debug("Table for Remote execution created");
                        } else {
                            DatabaseFactory.executeSQLUpdate(createPartitionTableStatement, this.vreConnection);
                            AnalysisLogger.getLogger().debug(String.format(createIndexStatement, this.default_hspec_suitable_table));
                            DatabaseFactory.executeUpdateNoTransaction(String.format(createIndexStatement, this.default_hspec_suitable_table), engine.getDatabaseDriver(), engine.getDatabaseUserName(), engine.getDatabasePassword(), engine.getDatabaseURL(), true);
                        }
                    }
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().trace("Distribution Generator->could not create table");
                    e.printStackTrace();
                }
                if (this.useDB) {
                    AnalysisLogger.getLogger().trace("Distribution Generator->deleting values");
                    this.deleteValues();
                }
            }
        }
        this.initEngine();
    }

    public void stopProcess() {
        this.interruptProcessing = true;
    }

    private void initEngine() {
        if (this.generatorAlgorithm == GenerationModel.AQUAMAPS) {
            this.generationAlgorithm = new AquamapsAlgorithm();
        }
        this.status = 0.0;
        this.interruptProcessing = false;
        this.remoteMultiplier = 1.0;
        this.remoteShift = 0.0;
        this.dynamicWriteQuery = insertionStatement.replace("%TABLENAME%", this.default_hspec_suitable_table);
        this.dynamicCSquareQuery = String.format(csquareCodeQuery, this.default_hcaf_table);
        this.dynamicHSpenQuery = selectAllSpeciesQuery.replace("%HSPEN%", this.default_hspen_table);
        this.dynamicHSpenMinmaxQuery = selectAllSpeciesObservationQuery.replace("%HSPEN%", this.default_hspen_maxminlat);
    }

    public void getBoundingBoxInformation(Object[] speciesInfoRow, Object[] speciesObservations) {
        Object[] row = speciesInfoRow;
        String $paramData_NMostLat = AquamapsAlgorithm.getElement(row, 28);
        String $paramData_SMostLat = AquamapsAlgorithm.getElement(row, 29);
        String $paramData_WMostLong = AquamapsAlgorithm.getElement(row, 30);
        String $paramData_EMostLong = AquamapsAlgorithm.getElement(row, 31);
        this.currentFAOAreas = AquamapsAlgorithm.getElement(row, 32);
        this.currentFAOAreas = this.generationAlgorithm.procFAO_2050(this.currentFAOAreas);
        this.currentSpeciesBoundingBoxInfo = this.generationAlgorithm.getBoundingBoxInfo($paramData_NMostLat, $paramData_SMostLat, $paramData_WMostLong, $paramData_EMostLong, speciesObservations, this.generationType);
    }

    public void generateHSPEC() throws Exception {
        if (("" + (Object)((Object)this.generatorAlgorithm)).startsWith("REMOTE")) {
            this.generatorAlgorithm = GenerationModel.valueOf(("" + (Object)((Object)this.generatorAlgorithm)).replace("REMOTE_", ""));
            AnalysisLogger.getLogger().warn("Required Algorithm is of Remote Type ");
            this.isRemoteGeneration = true;
            try {
                this.shutdownConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.generateRemoteHSPEC();
        } else {
            AnalysisLogger.getLogger().warn("Required Algorithm is of Standalone Type ");
            this.isRemoteGeneration = false;
            this.generateStandaloneHSPEC();
        }
    }

    public void generateRemoteHSPEC() throws Exception {
        try {
            RemoteHspecInputObject rhio = new RemoteHspecInputObject();
            rhio.userName = this.default_service_userName;
            rhio.environment = this.default_remote_environment;
            rhio.configuration = this.default_remote_properties;
            rhio.generativeModel = "" + (Object)((Object)this.generatorAlgorithm);
            String jdbcUrl = this.dbjdbcUrl;
            String userName = this.dbuserName;
            String password = this.dbpassword;
            jdbcUrl = jdbcUrl + ";username=" + userName + ";password=" + password;
            rhio.hcafTableName.tableName = this.default_hcaf_table;
            rhio.hcafTableName.jdbcUrl = jdbcUrl;
            rhio.hspecDestinationTableName.tableName = this.default_hspec_suitable_table;
            rhio.hspecDestinationTableName.jdbcUrl = jdbcUrl;
            rhio.hspenTableName.tableName = this.default_hspen_table;
            rhio.hspenTableName.jdbcUrl = jdbcUrl;
            rhio.occurrenceCellsTable.tableName = "maxminlat_" + this.default_hspen_table;
            rhio.occurrenceCellsTable.jdbcUrl = jdbcUrl;
            rhio.is2050 = this.generationType.equals("2050");
            rhio.isNativeGeneration = this.nativegeneration;
            rhio.nWorkers = this.numberOfthreads;
            this.remoteGenerationManager = new RemoteGenerationManager(this.default_remote_calculator);
            AnalysisLogger.getLogger().trace("REMOTE PROCESSING SUBMITTING JOB");
            this.remoteGenerationManager.submitJob(rhio);
            AnalysisLogger.getLogger().trace("REMOTE PROCESSING STARTED");
            boolean finish = false;
            while (!finish) {
                RemoteHspecOutputObject oo = this.remoteGenerationManager.retrieveCompleteStatus();
                if (this.interruptProcessing || oo.status.equals("DONE") || oo.status.equals("ERROR")) {
                    finish = true;
                    AnalysisLogger.getLogger().trace("REMOTE PROCESSING FINISHED");
                    if (oo.status.equals("ERROR")) {
                        throw new Exception("REMOTE ERROR REPORTED");
                    }
                }
                Thread.sleep(5000L);
            }
            AnalysisLogger.getLogger().trace("->END OF PROCEDURE");
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug("ERROR: " + e.getLocalizedMessage());
            throw e;
        }
        finally {
            this.shutdownConnection();
            this.status = 100.0;
            AnalysisLogger.getLogger().debug("COMPUTATION FINISHED" + this.status);
        }
    }

    public void generateStandaloneHSPEC() throws Exception {
        AnalysisLogger.getLogger().trace("Distribution Generator->populating species");
        this.populateSelectedSpecies();
        AnalysisLogger.getLogger().trace("Distribution Generator->getting squares");
        this.getCsquares();
        AnalysisLogger.getLogger().trace("Distribution Generator->getting all species information");
        this.getAllSpeciesInfo();
        this.csquaresNumber = this.csquares.size();
        int numOfChunks = this.csquaresNumber / chunksize;
        if (this.csquaresNumber % chunksize != 0) {
            ++numOfChunks;
        }
        AnalysisLogger.getLogger().trace("Distribution Generator->GENERATION STARTED");
        this.initializeThreads(this.numberOfthreads);
        this.tstart = System.currentTimeMillis();
        int overallcounter = 0;
        int numOfSpecies = this.selectedSpecies.size();
        this.numbOfProcessedSpecies = 0;
        for (Object species : this.selectedSpecies) {
            this.initBuffers();
            long t0 = System.currentTimeMillis();
            String speciesid = (String)species;
            this.getSpeciesInfo(speciesid);
            if (this.speciesObservations == null || this.speciesObservations.size() == 0) {
                Object[] defaultmaxmin = new Object[]{"90", "-90"};
                this.speciesObservations = new ArrayList<Object>();
                this.speciesObservations.add(defaultmaxmin);
            }
            this.getBoundingBoxInformation((Object[])this.speciesInfo.get(0), (Object[])this.speciesObservations.get(0));
            AnalysisLogger.getLogger().trace("Distribution Generator->ANALIZING SPECIES: " + speciesid);
            int currentThread = 0;
            int globalcounter = 0;
            long computationT0 = System.currentTimeMillis();
            for (int k = 0; k < numOfChunks; ++k) {
                int start = k * chunksize;
                this.wait4Thread(currentThread);
                this.startNewTCalc(currentThread, speciesid, start);
                if (++currentThread >= this.numberOfthreads) {
                    currentThread = 0;
                }
                this.status = (double)((int)((double)globalcounter * 100.0 / (double)numOfChunks * 100.0)) / 100.0;
                this.globalstatus = (double)overallcounter / (double)(numOfSpecies * numOfChunks) * 100.0;
                ++globalcounter;
                ++overallcounter;
            }
            for (int i = 0; i < this.numberOfthreads; ++i) {
                this.wait4Thread(i);
            }
            long computationT1 = System.currentTimeMillis();
            AnalysisLogger.getLogger().trace("Species Computation Finished in " + (computationT1 - computationT0) + " ms");
            this.insertCriteria();
            ++this.numbOfProcessedSpecies;
            long t1 = System.currentTimeMillis();
            long t3 = t1 - t0;
            AnalysisLogger.getLogger().trace("\nDistribution Generator->Species Computation and Writing Finished in: " + t3 + " ms");
            if (!this.interruptProcessing) continue;
            break;
        }
        long tend = System.currentTimeMillis();
        long ttotal = tend - this.tstart;
        this.globalstatus = 100.0;
        AnalysisLogger.getLogger().warn("\nDistribution Generator->Algorithm finished in: " + (double)ttotal / 60000.0 + " min\n");
        this.executorService.shutdown();
        this.shutdownConnection();
    }

    private void startNewTCalc(int index, String species, int start) {
        this.threadActivity[index] = true;
        ThreadCalculator tc = new ThreadCalculator(this, index, species, start);
        this.executorService.submit(tc);
    }

    public static void main(String[] args) throws Exception {
        EngineConfiguration e = new EngineConfiguration();
        e.setConfigPath("./cfg");
        DistributionGenerator aag = new DistributionGenerator(null);
        aag.generateHSPEC();
    }

    private class ThreadCalculator
    implements Callable<Integer> {
        int index;
        int startindex;
        String species;
        DistributionGenerator aag;

        public ThreadCalculator(DistributionGenerator aag, int index, String species, int start) {
            this.index = index;
            this.species = species;
            this.startindex = start;
            this.aag = aag;
        }

        @Override
        public Integer call() {
            try {
                if (DistributionGenerator.this.nativegeneration) {
                    this.aag.calcProbNative(this.species, this.startindex);
                } else {
                    this.aag.calcProb(this.species, this.startindex);
                }
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().trace("" + e);
                e.printStackTrace();
            }
            DistributionGenerator.this.threadActivity[this.index] = false;
            return 0;
        }
    }
}

