/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.model.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Nodes;

public class InnerNode
extends Node {
    private List<Edge> edges = new ArrayList<Edge>();

    public InnerNode(InnerNode n) {
        super(n.id(), n.state(), n.attributes());
        for (Edge e : n.edges()) {
            this.add(new Edge(e));
        }
    }

    public InnerNode() {
    }

    public InnerNode(String id) {
        super(id);
    }

    public InnerNode(String id, Edge ... edges) {
        this(id, (Node.State)null, (Map<QName, String>)null, edges);
    }

    public InnerNode(Edge ... edges) {
        this((String)null, edges);
    }

    public InnerNode(String id, Map<QName, String> attributes, Edge ... edges) {
        this(id, null, attributes, edges);
    }

    public InnerNode(String id, Node.State state, Map<QName, String> attributes, Edge ... edges) {
        super(id, state, attributes);
        this.edges = new ArrayList<Edge>();
        this.add(edges);
    }

    public synchronized List<Node> children() {
        ArrayList<Node> children = new ArrayList<Node>();
        for (Edge e : this.edges()) {
            children.add(e.target());
        }
        return children;
    }

    public synchronized <T extends Node> List<T> children(Class<T> type) {
        ArrayList<T> children = new ArrayList<T>();
        for (Edge e : this.edges()) {
            if (!type.isInstance(e.target())) continue;
            children.add(type.cast(e.target()));
        }
        return children;
    }

    public synchronized List<Node> children(QName label) {
        ArrayList<Node> children = new ArrayList<Node>();
        for (Edge e : this.edges(label)) {
            children.add(e.target());
        }
        return children;
    }

    public synchronized <T extends Node> List<T> children(Class<T> type, QName label) {
        ArrayList<T> children = new ArrayList<T>();
        for (Edge e : this.edges(label)) {
            if (!type.isInstance(e.target())) continue;
            children.add(type.cast(e.target()));
        }
        return children;
    }

    public synchronized List<Node> children(String name) throws IllegalArgumentException {
        return this.children(new QName(name));
    }

    public synchronized <T extends Node> List<T> children(Class<T> type, String name) throws IllegalArgumentException {
        return this.children(type, new QName(name));
    }

    public synchronized List<Node> children(String ns, String name) throws IllegalArgumentException {
        return this.children(new QName(ns, name));
    }

    public synchronized <T extends Node> List<T> children(Class<T> type, String ns, String name) throws IllegalArgumentException {
        return this.children(type, new QName(ns, name));
    }

    public synchronized Node descendant(String ... descendantIDs) throws IllegalArgumentException, IllegalStateException {
        if (descendantIDs == null || descendantIDs.length == 0) {
            throw new IllegalArgumentException("unspecified descendant identifiers");
        }
        String childID = descendantIDs[0];
        Node child = null;
        for (Node c : this.children()) {
            if (c.id() == null || !c.id().equals(childID)) continue;
            child = c;
        }
        if (child == null) {
            throw new IllegalStateException("no descendant with identifier " + childID);
        }
        if (descendantIDs.length == 1) {
            return child;
        }
        if (child instanceof InnerNode) {
            String[] rest = new String[descendantIDs.length - 1];
            System.arraycopy(descendantIDs, 1, rest, 0, descendantIDs.length - 1);
            return ((InnerNode)child).descendant(rest);
        }
        throw new IllegalStateException("no descendant past identifier " + childID);
    }

    public synchronized <T extends Node> T descendant(Class<T> type, String ... descendantIDs) throws IllegalStateException {
        Node descendant = this.descendant(descendantIDs);
        if (type.isInstance(descendant)) {
            return (T)((Node)type.cast(descendant));
        }
        throw new IllegalStateException("no descendant of the specified tree type");
    }

    public synchronized List<Node> descendants(QName ... labels) throws IllegalArgumentException {
        if (labels == null || labels.length == 0) {
            throw new IllegalArgumentException("no labels specified");
        }
        return this.descendantsRec(labels);
    }

    public synchronized <T extends Node> List<T> descendants(Class<T> type, QName ... labels) throws IllegalArgumentException {
        ArrayList<T> typed = new ArrayList<T>();
        for (Node n : this.descendants(labels)) {
            if (!type.isInstance(n)) continue;
            typed.add(type.cast(n));
        }
        return typed;
    }

    private synchronized List<Node> descendantsRec(QName ... labels) throws IllegalArgumentException {
        if (labels.length == 1) {
            return this.children(labels[0]);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        QName label = labels[0];
        QName[] rest = new QName[labels.length - 1];
        System.arraycopy(labels, 1, rest, 0, labels.length - 1);
        for (Node child : this.children(label)) {
            if (!(child instanceof InnerNode)) continue;
            nodes.addAll(((InnerNode)child).descendantsRec(rest));
        }
        return nodes;
    }

    public synchronized List<Node> descendants(String ... labels) throws IllegalArgumentException {
        QName[] qlabels = new QName[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            qlabels[i] = new QName(labels[i]);
        }
        return this.descendants(qlabels);
    }

    public synchronized <T extends Node> List<T> descendants(Class<T> type, String ... labels) throws IllegalArgumentException {
        QName[] qlabels = new QName[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            qlabels[i] = new QName(labels[i]);
        }
        return this.descendants(type, qlabels);
    }

    public synchronized Node child(QName label) throws IllegalStateException {
        return this.edge(label).target();
    }

    public synchronized <T extends Node> T child(Class<T> type, QName label) throws IllegalStateException {
        List<T> children = this.children(type, label);
        if (children.size() != 1) {
            throw new IllegalStateException("not one child of the right type");
        }
        return (T)((Node)children.get(0));
    }

    public synchronized Node child(String name) throws IllegalArgumentException, IllegalStateException {
        return this.child(new QName(name));
    }

    public synchronized <T extends Node> T child(Class<T> type, String name) throws IllegalArgumentException, IllegalStateException {
        return this.child(type, new QName(name));
    }

    public synchronized Node child(String ns, String name) throws IllegalArgumentException, IllegalStateException {
        return this.child(new QName(ns, name));
    }

    public synchronized <T extends Node> T child(Class<T> type, String ns, String name) throws IllegalArgumentException, IllegalStateException {
        return this.child(type, new QName(ns, name));
    }

    public synchronized List<Edge> edges() {
        return new ArrayList<Edge>(this.edges);
    }

    public synchronized List<Edge> edges(QName l) {
        ArrayList<Edge> es = new ArrayList<Edge>();
        for (Edge e : this.edges) {
            if (!Nodes.matches(e.label(), l)) continue;
            es.add(e);
        }
        return es;
    }

    public synchronized List<Edge> edges(String ns, String l) throws IllegalArgumentException {
        return this.edges(new QName(ns, l));
    }

    public synchronized List<Edge> edges(String l) throws IllegalArgumentException {
        return this.edges(new QName(l));
    }

    public synchronized boolean hasEdge(QName l) {
        return this.edges(l).size() > 0;
    }

    public synchronized boolean hasEdge(String l) throws IllegalArgumentException {
        return this.hasEdge(new QName(l));
    }

    public synchronized boolean hasEdge(String ns, String l) throws IllegalArgumentException {
        return this.hasEdge(new QName(ns, l));
    }

    public synchronized Edge edge(QName l) throws IllegalStateException {
        List<Edge> es = this.edges(l);
        if (es.size() != 1) {
            throw new IllegalStateException("no edge or too many edges with name " + l);
        }
        return es.get(0);
    }

    public synchronized Edge edge(String l) throws IllegalStateException, IllegalArgumentException {
        return this.edge(new QName(l));
    }

    public synchronized Edge edge(String ns, String l) throws IllegalStateException, IllegalArgumentException {
        return this.edge(new QName(ns, l));
    }

    public synchronized List<QName> labels() {
        ArrayList<QName> lbls = new ArrayList<QName>();
        for (Edge e : this.edges) {
            if (lbls.contains(e.label())) continue;
            lbls.add(e.label());
        }
        return lbls;
    }

    public synchronized List<QName> labels(QName l) {
        ArrayList<QName> lbls = new ArrayList<QName>();
        for (QName lbl : this.labels()) {
            if (!Nodes.matches(lbl, l)) continue;
            lbls.add(lbl);
        }
        return lbls;
    }

    public synchronized boolean remove(List<Edge> es) {
        return this.edges.removeAll(es);
    }

    public synchronized boolean remove(Edge ... es) {
        return this.remove(Arrays.asList(es));
    }

    public synchronized Node remove(String childID) throws IllegalStateException {
        for (Edge e : this.edges()) {
            if (e.target().id() == null || !e.target().id().equals(childID)) continue;
            this.remove(e);
            return e.target();
        }
        throw new IllegalStateException("no child with id " + childID);
    }

    public synchronized List<Node> remove(String ... childIDs) {
        ArrayList<Node> children = new ArrayList<Node>();
        for (String id : childIDs) {
            try {
                children.add(this.remove(id));
            }
            catch (IllegalStateException tolerate) {
                // empty catch block
            }
        }
        return children;
    }

    public synchronized boolean add(List<Edge> es) {
        boolean added = false;
        for (Edge e : es) {
            e.target().setParent(this);
            added = this.edges.add(e) || added;
        }
        return added;
    }

    public synchronized boolean add(Edge ... es) {
        return this.add(Arrays.asList(es));
    }

    @Override
    protected synchronized void delete() {
        super.delete();
        this.edges.clear();
    }

    @Override
    public synchronized InnerNode delta(Node f) throws IllegalArgumentException, IllegalStateException {
        InnerNode delta = (InnerNode)super.delta(f);
        InnerNode future = (InnerNode)f;
        List<Edge> copy = future.edges();
        for (Edge thisEdge : this.edges()) {
            Node thisChild = thisEdge.target();
            Node futureChild = null;
            for (Edge futureEdge : future.edges()) {
                if (futureEdge.target().id() == null || !futureEdge.target().id().equals(thisChild.id())) continue;
                futureChild = futureEdge.target();
                copy.remove(futureEdge);
            }
            if (futureChild == null) {
                Edge deltaEdge = new Edge(thisEdge);
                delta.add(deltaEdge);
                deltaEdge.target().delete();
                delta.state(Node.State.MODIFIED);
                continue;
            }
            Node deltaChild = thisChild.delta(futureChild);
            if (deltaChild.state() != Node.State.MODIFIED) continue;
            delta.add(new Edge(thisEdge.label(), deltaChild));
            delta.state(Node.State.MODIFIED);
        }
        for (Edge newEdge : copy) {
            Edge deltaEdge = new Edge(newEdge);
            InnerNode.markAsNew(deltaEdge.target());
            delta.edges.add(deltaEdge);
            delta.state(Node.State.MODIFIED);
        }
        return delta;
    }

    protected static void markAsNew(Node n) throws IllegalStateException {
        n.state(Node.State.NEW);
        if (n instanceof InnerNode) {
            for (Edge e : ((InnerNode)n).edges()) {
                InnerNode.markAsNew(e.target());
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[").append(this.state() == null ? "" : this.state().name() + " ").append(this.id() != null ? "id:" + (this.id().length() > 3 ? this.id().substring(0, Math.min(this.id().length(), 3)) + ".." : this.id()) + " " : "");
        for (Map.Entry<QName, String> attr : this.attributes().entrySet()) {
            b.append("@" + (attr.getKey().getPrefix().length() > 0 ? attr.getKey().getPrefix() + ":" : "") + attr.getKey() + "=" + attr.getValue() + " ");
        }
        for (Edge e : this.edges) {
            b.append(e + " ");
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof InnerNode)) {
            return false;
        }
        HashSet<Edge> s1 = new HashSet<Edge>(this.edges);
        HashSet<Edge> s2 = new HashSet<Edge>(((InnerNode)obj).edges);
        return super.equals(obj) && s1.equals(s2);
    }

    @Override
    public int hashCode() {
        return ((Object)this.edges).hashCode() + 31 * (super.hashCode() + 527);
    }

    public static void main(String[] args) {
        ArrayList<Integer> l1 = new ArrayList<Integer>();
        l1.add(1);
        l1.add(2);
        l1.add(3);
        ArrayList<Integer> l2 = new ArrayList<Integer>();
        l2.add(1);
        l2.add(3);
        l2.add(2);
        System.out.println(((Object)l1).equals(l2));
        System.out.println(new HashSet(l1).equals(new HashSet(l2)));
    }
}

