/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.model.trees;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.InnerNode;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Leaf;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Nodes;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class Bindings {
    private static final DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    private static TransformerFactory tracFactory = TransformerFactory.newInstance();
    public static final String GDOC_NS = "http://gcube-system.org/namespaces/contentmanagement/gdoc";
    public static final String GDOC_NAME = "gdoc";
    public static final String GDOC_PREFIX = "g";
    public static final String GDOC_URI = "uri";
    public static final String DEFAULT_NODE_NAME = "node";
    public static final String GDOC_ID_ATTR = "id";
    public static final String GDOC_STATUS_ATTR = "state";
    public static final String GDOC_COLLID_ATTR = "collID";

    public static Element toElement(GDoc doc) throws Exception {
        Element root = Bindings.nodeToElement(doc, new QName(GDOC_NS, GDOC_NAME, GDOC_PREFIX));
        if (doc.collectionID() != null) {
            root.setAttributeNS(GDOC_NS, "g:collID", doc.collectionID());
        }
        return root;
    }

    public static Element nodeToElement(Node node, QName ... name) throws Exception {
        QName qname = name.length == 0 ? new QName(GDOC_NS, DEFAULT_NODE_NAME, GDOC_PREFIX) : name[0];
        Document document = domFactory.newDocumentBuilder().newDocument();
        Element root = Bindings.toElementRec(document, qname, node);
        document.appendChild(root);
        return root;
    }

    private static Element toElementRec(Document doc, QName label, Node node) throws Exception {
        String name = label.getPrefix().length() == 0 ? label.getLocalPart() : label.getPrefix() + ":" + label.getLocalPart();
        Element e = doc.createElementNS(label.getNamespaceURI(), name);
        if (node.id() != null) {
            e.setAttributeNS(GDOC_NS, "g:id", node.id());
        }
        if (node.state() != null) {
            e.setAttributeNS(GDOC_NS, "g:state", node.state().name());
        }
        for (Map.Entry<QName, String> attr : node.attributes().entrySet()) {
            String attrName = attr.getKey().getLocalPart();
            if (attr.getKey().getPrefix().length() > 0) {
                attrName = attr.getKey().getPrefix() + ":" + attrName;
            }
            String attrNS = attr.getKey().getNamespaceURI();
            e.setAttributeNS(attrNS, attrName, attr.getValue() == null ? "_null_" : attr.getValue());
        }
        if (node instanceof InnerNode) {
            for (Edge edge : ((InnerNode)node).edges()) {
                e.appendChild(Bindings.toElementRec(doc, edge.label(), edge.target()));
            }
        } else {
            String val = ((Leaf)node).value();
            e.appendChild(doc.createTextNode(val == null ? "_null_" : val));
        }
        return e;
    }

    public static GDoc fromElement(Element e) throws Exception {
        InnerNode root = (InnerNode)Bindings.nodeFromElement(e);
        GDoc doc = Nodes.gdoc(root.id(), new Edge[0]);
        if (root.hasAttribute(GDOC_NS, GDOC_COLLID_ATTR)) {
            doc.collectionID(root.attribute(GDOC_NS, GDOC_COLLID_ATTR));
            root.removeAttribute(GDOC_NS, GDOC_COLLID_ATTR);
        }
        doc.state(root.state());
        doc.add(root.edges());
        for (Map.Entry<QName, String> a : root.attributes().entrySet()) {
            doc.setAttribute(a.getKey(), a.getValue());
        }
        return doc;
    }

    public static Node nodeFromElement(Element e) throws Exception {
        return Bindings.fromElementRec(e);
    }

    private static Node fromElementRec(Element e) throws Exception {
        NodeList children;
        Node node = null;
        NamedNodeMap map = e.getAttributes();
        String id = null;
        if (e.hasAttributeNS(GDOC_NS, GDOC_ID_ATTR)) {
            id = e.getAttributeNS(GDOC_NS, GDOC_ID_ATTR);
            map.removeNamedItemNS(GDOC_NS, GDOC_ID_ATTR);
        }
        Node.State state = null;
        if (e.hasAttributeNS(GDOC_NS, GDOC_STATUS_ATTR)) {
            state = Node.State.valueOf(e.getAttributeNS(GDOC_NS, GDOC_STATUS_ATTR));
            map.removeNamedItemNS(GDOC_NS, GDOC_STATUS_ATTR);
        }
        if ((children = e.getChildNodes()).getLength() == 1 && children.item(0).getNodeType() == 3) {
            node = new Leaf(id, state, children.item(0).getNodeValue().equals("_null_") ? null : children.item(0).getNodeValue(), null);
        } else {
            ArrayList<Edge> edges = new ArrayList<Edge>();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                Element child = (Element)children.item(i);
                QName name = child.getPrefix() == null ? new QName(child.getNamespaceURI(), child.getLocalName()) : new QName(child.getNamespaceURI(), child.getLocalName(), child.getPrefix());
                edges.add(new Edge(name, Bindings.fromElementRec(child)));
            }
            node = new InnerNode(id, state, null, edges.toArray(new Edge[0]));
        }
        for (int i = 0; i < map.getLength(); ++i) {
            String prefix = map.item(i).getPrefix();
            if (prefix != null && prefix.equals("xmlns")) continue;
            node.setAttribute(prefix == null ? new QName(map.item(i).getNamespaceURI(), map.item(i).getLocalName()) : new QName(map.item(i).getNamespaceURI(), map.item(i).getLocalName(), map.item(i).getPrefix()), map.item(i).getNodeValue().equals("_null_") ? null : map.item(i).getNodeValue());
        }
        return node;
    }

    public static void toXML(GDoc doc, Writer w, boolean ... writeDeclaration) throws Exception {
        Transformer transformer = tracFactory.newTransformer();
        if (writeDeclaration.length > 0) {
            transformer.setOutputProperty("omit-xml-declaration", writeDeclaration[0] ? "no" : "yes");
        }
        transformer.transform(new DOMSource(Bindings.toElement(doc)), new StreamResult(w));
    }

    public static void nodeToXML(Node node, Writer w, QName ... name) throws Exception {
        tracFactory.newTransformer().transform(new DOMSource(Bindings.nodeToElement(node, name)), new StreamResult(w));
    }

    public static GDoc fromXML(Reader r) throws Exception {
        DOMResult result = new DOMResult();
        tracFactory.newTransformer().transform(new StreamSource(r), result);
        return Bindings.fromElement(((Document)result.getNode()).getDocumentElement());
    }

    public static GDoc fromXML(InputStream in) throws Exception {
        return Bindings.fromXML(new InputStreamReader(in));
    }

    public static Node nodeFromXML(Reader r) throws Exception {
        DOMResult result = new DOMResult();
        tracFactory.newTransformer().transform(new StreamSource(r), result);
        return Bindings.nodeFromElement(((Document)result.getNode()).getDocumentElement());
    }

    public static Node nodeFromXML(InputStream in) throws Exception {
        return Bindings.nodeFromXML(new InputStreamReader(in));
    }
}

