/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.model.protocol.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ReadManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Bindings;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;

public class CMSURLConnection
extends URLConnection {
    Node node;

    public CMSURLConnection(URL url) {
        super(url);
    }

    @Override
    public synchronized void connect() throws IOException {
        try {
            this.node = ReadManagerCall.get(this.url.toURI(), GCUBEScopeManager.DEFAULT.getScope(), new GCUBESecurityManager[0]);
            this.connected = true;
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            StringWriter w = new StringWriter();
            if (this.node instanceof GDoc) {
                Bindings.toXML((GDoc)this.node, w, new boolean[0]);
            } else {
                Bindings.nodeToXML(this.node, w, new QName[0]);
            }
            return new ByteArrayInputStream(w.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }
}

