/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.model.predicates;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.gcube.contentmanagement.contentmanager.stubs.model.constraints.Constraint;
import org.gcube.contentmanagement.contentmanager.stubs.model.constraints.Constraints;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.AnyPredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.AtLeast;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Bool;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Calendar;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.CutTreePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Date;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.EdgePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.LeafPredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Many;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Num;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.One;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Only;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Opt;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.RID;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Text;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;

public class Predicates {
    private static JAXBContext context;
    public static final String any = ".*";
    public static final boolean C = true;

    public static Marshaller getMarshaller() throws JAXBException {
        return context.createMarshaller();
    }

    public static Unmarshaller getUnMarshaller() throws JAXBException {
        return context.createUnmarshaller();
    }

    public static final AnyPredicate any() {
        return new AnyPredicate();
    }

    public static final Predicate clone(Predicate predicate) throws Exception {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(s);
        os.writeObject(predicate);
        os.close();
        ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(s.toByteArray()));
        return (Predicate)is.readObject();
    }

    public static final EdgePredicate clone(EdgePredicate predicate) throws Exception {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(s);
        os.writeObject(predicate);
        os.close();
        ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(s.toByteArray()));
        return (EdgePredicate)is.readObject();
    }

    public static final TreePredicate tree(EdgePredicate ... eps) {
        return new TreePredicate(Arrays.asList(eps));
    }

    public static final TreePredicate hasPath(String ... ids) throws IllegalArgumentException {
        if (ids == null || ids.length < 1) {
            throw new IllegalArgumentException();
        }
        TreePredicate predicate = Predicates.id(ids[ids.length - 1], Predicates.tree(new EdgePredicate[0]));
        for (int i = ids.length - 2; i >= 0; --i) {
            predicate = Predicates.id(ids[i], Predicates.tree(Predicates.atleast(any, (Predicate)predicate)));
        }
        return predicate;
    }

    public static final TreePredicate hasLabelPath(String ... labels) throws IllegalArgumentException {
        ArrayList<QName> qnames = new ArrayList<QName>();
        for (String label : labels) {
            qnames.add(new QName(label));
        }
        return Predicates.hasLabelPath(qnames.toArray(new QName[0]));
    }

    public static final TreePredicate hasLabelPath(QName ... labels) throws IllegalArgumentException {
        if (labels == null || labels.length < 1) {
            throw new IllegalArgumentException();
        }
        TreePredicate predicate = Predicates.tree(Predicates.atleast(labels[labels.length - 1], (Predicate)Predicates.any()));
        for (int i = labels.length - 2; i >= 0; --i) {
            predicate = Predicates.tree(Predicates.atleast(labels[i], (Predicate)predicate));
        }
        return predicate;
    }

    public static EdgePredicate cond(EdgePredicate ep) {
        ep.setAsCondition();
        return ep;
    }

    public static final EdgePredicate one(QName l, Predicate predicate) {
        return new One(l, predicate);
    }

    public static final EdgePredicate one(String l, Predicate predicate) {
        return new One(new QName(l), predicate);
    }

    public static final TreePredicate id(LeafPredicate<?, ?> idp, TreePredicate p) {
        p.setIdPredicate(idp);
        return p;
    }

    public static final TreePredicate id(String identifier, TreePredicate p) {
        return Predicates.id(Predicates.text(Constraints.is(identifier)), p);
    }

    public static final EdgePredicate one(String ns, String l, Predicate predicate) {
        return new One(new QName(ns, l), predicate);
    }

    public static final EdgePredicate opt(QName l, Predicate np) {
        return new Opt(l, np);
    }

    public static final EdgePredicate opt(String l, Predicate np) {
        return new Opt(new QName(l), np);
    }

    public static final EdgePredicate opt(String ns, String l, Predicate np) {
        return new Opt(new QName(ns, l), np);
    }

    public static final EdgePredicate atleast(QName l, Predicate np) {
        return new AtLeast(l, np);
    }

    public static final EdgePredicate atleast(String l, Predicate np) {
        return new AtLeast(new QName(l), np);
    }

    public static final EdgePredicate atleast(String ns, String l, Predicate np) {
        return new AtLeast(new QName(ns, l), np);
    }

    public static final EdgePredicate many(QName l, Predicate np) {
        return new Many(l, np);
    }

    public static final EdgePredicate many(String l, Predicate np) {
        return new Many(new QName(l), np);
    }

    public static final EdgePredicate many(String ns, String l, Predicate np) {
        return new Many(new QName(ns, l), np);
    }

    public static final EdgePredicate only(QName l, Predicate np) {
        return new Only(l, np);
    }

    public static final EdgePredicate only(String l, Predicate np) {
        return new Only(new QName(l), np);
    }

    public static final EdgePredicate only(String ns, String l, Predicate np) {
        return new Only(new QName(ns, l), np);
    }

    public static EdgePredicate tail() {
        return Predicates.many(any, (Predicate)Predicates.any());
    }

    public static TreePredicate cut(TreePredicate tp) {
        return new CutTreePredicate(tp.getPredicates());
    }

    public static Text text(Constraint<? super String> c) {
        return new Text(c);
    }

    public static Text text() {
        return new Text(Constraints.anyval);
    }

    public static Num num(Constraint<? super Double> c) {
        return new Num(c);
    }

    public static Num num() {
        return new Num(Constraints.anyval);
    }

    public static Bool bool(Constraint<? super Boolean> c) {
        return new Bool(c);
    }

    public static Bool bool() {
        return new Bool(Constraints.anyval);
    }

    public static Date date(Constraint<? super java.util.Date> c) {
        return new Date(c);
    }

    public static Date date() {
        return new Date(Constraints.anyval);
    }

    public static RID uri(Constraint<? super URI> c) {
        return new RID(c);
    }

    public static RID uri() {
        return new RID(Constraints.anyval);
    }

    public static Calendar calendar(Constraint<? super java.util.Calendar> c) {
        return new Calendar(c);
    }

    public static Calendar calendar() {
        return new Calendar(Constraints.anyval);
    }

    static {
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{TreePredicate.class});
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

