package org.gcube.contentmanagement.codelistmanager.util.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.List;

import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.util.ImporterInterface;

import net.sf.csv4j.CSVReaderProcessor;

public class CSVImport extends ImporterInterface{

	private File csvFile;
	protected boolean hasHeader= true;
	protected char delimiter =',';
	protected String encoding;
	protected int totalLines=-1;
	
	protected InitializerProcessor initializer;
	protected ImportLineProcessor lineProcessor;	
	
	public CSVImport(File csvFile, boolean hasHeader, char delimiter,
			String encoding, InitializerProcessor initializer, ImportLineProcessor lineprocessor) {
		super();
		this.csvFile = csvFile;
		this.hasHeader = hasHeader;
		this.delimiter = delimiter;
		this.encoding = encoding;
		this.initializer = initializer;
		this.lineProcessor = lineprocessor;
	}
	
	public void initialize() throws Exception {
		//System.out.println("initilizing");
		CSVReaderProcessor processor= new CSVReaderProcessor();
		processor.setDelimiter(this.delimiter);
		processor.setHasHeader(this.hasHeader);
		processor.processStream( new InputStreamReader(new FileInputStream(csvFile), this.encoding), initializer);
		this.totalLines= initializer.getTotalLines();
	}


	
	public void process(SimpleTable table, ProgresChangedEvent event) throws Exception {
		CSVReaderProcessor processor= new CSVReaderProcessor();
		processor.setDelimiter(this.delimiter);
		processor.setHasHeader(this.hasHeader);
		lineProcessor.setTable(table);
		lineProcessor.setEvent(event);
		processor.processStream( new InputStreamReader(new FileInputStream(csvFile), this.encoding), lineProcessor);
	}

	/**
	 * @return the totalLines
	 */
	public int getTotalLines() {
		return totalLines;
	}

	public List<ColumnDefinition>  getTableDefinition(){
		if (initializer == null) return null;
		return initializer.getTableDefinition();
	}
	
	public Hashtable<String, TableField > getFieldsName(){
		if (initializer == null) return null;
		return initializer.getFieldNames();
	}

}
