/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.codelistmanager.util.opensdmx;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;
import org.gcube.contentmanagement.codelistmanager.util.ImporterInterface;
import org.gcube.contentmanagement.codelistmanager.util.csv.ProgresChangedEvent;

public abstract class SDMXImport
extends ImporterInterface {
    protected int progress = 0;
    protected int totalLine = 0;
    protected List<ColumnDefinition> tableDefinition = new ArrayList<ColumnDefinition>();
    protected Hashtable<String, TableField> tableFields = new Hashtable();
    protected List<FieldDefinition> fieldsDefinition;

    public abstract String getAgencyId();

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getValidFrom();

    public abstract String getValidTo();

    public abstract float getVersion();

    public abstract boolean isFinal();

    @Override
    public int getTotalLines() {
        return this.totalLine;
    }

    @Override
    public List<ColumnDefinition> getTableDefinition() {
        return this.tableDefinition;
    }

    @Override
    public Hashtable<String, TableField> getFieldsName() {
        return this.tableFields;
    }

    protected abstract List<FieldDefinition> retrieveFieldsDefinition();

    @Override
    public abstract void process(SimpleTable var1, ProgresChangedEvent var2) throws Exception;

    @Override
    public void initialize() throws Exception {
        this.fieldsDefinition = this.retrieveFieldsDefinition();
        ColumnDefinition colDef = (ColumnDefinition)DBSession.getImplementation(ColumnDefinition.class);
        colDef.setLabel("ID");
        colDef.setType(new Type(Type.Types.INTEGER, new int[]{8}));
        colDef.setSpecification(new Specification[]{Specification.NOT_NULL, Specification.AUTO_INCREMENT});
        this.tableDefinition.add(colDef);
        int i = 0;
        for (FieldDefinition fieldDefinition : this.fieldsDefinition) {
            colDef = (ColumnDefinition)DBSession.getImplementation(ColumnDefinition.class);
            colDef.setLabel("field" + i);
            colDef.setType(new Type(Type.Types.STRING, fieldDefinition.getLength()));
            this.tableDefinition.add(colDef);
            this.tableFields.put("field" + i, new TableField("field" + i, fieldDefinition.getFieldname(), fieldDefinition.getType(), Type.Types.STRING, fieldDefinition.getLength()));
            ++i;
        }
    }

    protected class FieldDefinition {
        private String fieldname;
        private int[] length;
        private ColumnReference type;

        public FieldDefinition(String fieldname) {
            this.fieldname = fieldname;
            this.length = new int[]{0, 0};
            this.type = new ColumnReference(TableField.ColumnType.Undefined);
        }

        public FieldDefinition(String fieldname, int[] length, ColumnReference type) {
            this.fieldname = fieldname;
            this.length = length;
            this.type = type;
        }

        public String getFieldname() {
            return this.fieldname;
        }

        public void setFieldname(String fieldname) {
            this.fieldname = fieldname;
        }

        public ColumnReference getType() {
            return this.type;
        }

        public void setType(ColumnReference type) {
            this.type = type;
        }

        public int[] getLength() {
            return this.length;
        }

        public void setLength(int[] length) {
            this.length = length;
        }

        private SDMXImport getOuterType() {
            return SDMXImport.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.fieldname == null ? 0 : this.fieldname.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldDefinition other = (FieldDefinition)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.fieldname == null ? other.fieldname != null : !this.fieldname.equals(other.fieldname));
        }
    }
}

