package org.gcube.contentmanagement.discovery;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;

public class InfrastructureDialoguer {
	public String scope;
	
	public InfrastructureDialoguer(String scope){
		ScopeProvider.instance.set(scope);
		this.scope = scope;
	}
	
	public void getDatabaseInfo(String resourceName) throws Exception{
		System.out.println("Searching for Database "+resourceName+" in scope "+scope);
		SimpleQuery query = queryFor(ServiceEndpoint.class);
//		 query.addCondition("$resource/Profile/Category/text() eq 'Database' and $resource/Profile/Name eq 'StatisticalManagerDataBase' ");
//		query.addCondition("$resource/Profile/Category/text() eq 'Database' and $resource/Profile/Name eq '"+resourceName+"' ");
		query.addCondition("$resource/Profile/Name eq '"+resourceName+"' ");
		 DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
		 List<ServiceEndpoint> resources = client.submit(query);
		 if (resources==null || resources.size()==0){
			 throw new Exception("No resource named "+resourceName+" available in scope "+scope);
		 }
		 else{
			 AccessPoint ap = resources.get(0).profile().accessPoints().iterator().next();
			 System.out.println(ap.address());
			 System.out.println(ap.username());
			 System.out.println(ap.password());
//			 System.out.println(StringEncrypter.getEncrypter().decrypt(ap.password().trim()));
			 
			 for (ServiceEndpoint.Property property:ap.properties()){
				 System.out.println(property.value()); 
			 }
		 }
		 
	}
	
	public List<String> getWPSGcoreEndpoints(String dumpfile) throws Exception{
		 System.out.println("Searching for Algorithms in scope "+scope);
		SimpleQuery query = queryFor(GCoreEndpoint.class);
		query.addCondition("$resource/Profile/ServiceClass eq 'WPS' ");
		 DiscoveryClient<GCoreEndpoint> client = clientFor(GCoreEndpoint.class);
		 List<GCoreEndpoint> resources = client.submit(query);
		 if (resources==null || resources.size()==0){
			 throw new Exception("No WPS resource available in scope "+scope);
		 }
		List<String> resourcesNames = new ArrayList<String>(); 
		 System.out.println("Found "+resources.size()+" resources");
		 FileWriter fw = new FileWriter(new File(dumpfile)); 
		for (GCoreEndpoint resource: resources){
//			System.out.println(resource);
//			System.out.println(resource.type());
//			System.out.println(resource.version());
//			System.out.println(resource.id());
//			System.out.println(resource.profile().serviceName());
//			System.out.println(resource.profile().serviceId());
			String uri = resource.profile().endpoints().iterator().next().uri().toString();
			URL url = new URL(uri);
			String host = url.getHost();
			System.out.println(host);
			fw.write(host+System.lineSeparator());
		} 
			fw.close();
		return resourcesNames;
		
	}
	
	public List<String> getAlgorithmsInScope() throws Exception{
		 System.out.println("Searching for Algorithms in scope "+scope);
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType eq 'StatisticalManagerAlgorithm' ");
		 DiscoveryClient<GenericResource> client = clientFor(GenericResource.class);
		 List<GenericResource> resources = client.submit(query);
		 if (resources==null || resources.size()==0){
			 throw new Exception("No resource named StatisticalManagerAlgorithm available in scope "+scope);
		 }
		List<String> resourcesNames = new ArrayList<String>(); 
		 System.out.println("Found "+resources.size()+" resources");
		for (GenericResource resource: resources){
			resourcesNames.add(resource.profile().name());
		} 
		return resourcesNames;
		
	}
	
	public static void main(String[] args) throws Exception{
//		InfrastructureDialoguer dialoguer = new InfrastructureDialoguer("/gcube/devsec/devVRE");
		InfrastructureDialoguer dialoguer = new InfrastructureDialoguer(args[0]);
//		dialoguer.getDatabaseInfo("StatisticalManagerDataBase");
//		dialoguer.getDatabaseInfo("FishBase");
		dialoguer.getWPSGcoreEndpoints(args[1]);
	}
	
}
