/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.discovery;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class InfrastructureDialoguer {
    public String scope;

    public InfrastructureDialoguer(String scope) {
        ScopeProvider.instance.set(scope);
        this.scope = scope;
    }

    public void getDatabaseInfo(String resourceName) throws Exception {
        System.out.println("Searching for Database " + resourceName + " in scope " + this.scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name eq '" + resourceName + "' ");
        DiscoveryClient<ServiceEndpoint> client = ICFactory.clientFor(ServiceEndpoint.class);
        List<ServiceEndpoint> resources = client.submit(query);
        if (resources == null || resources.size() == 0) {
            throw new Exception("No resource named " + resourceName + " available in scope " + this.scope);
        }
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)resources.get(0).profile().accessPoints().iterator().next();
        System.out.println(ap.address());
        System.out.println(ap.username());
        System.out.println(ap.password());
        for (ServiceEndpoint.Property property : ap.properties()) {
            System.out.println(property.value());
        }
    }

    public List<String> getWPSGcoreEndpoints(String dumpfile) throws Exception {
        System.out.println("Searching for Algorithms in scope " + this.scope);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass eq 'WPS' ");
        DiscoveryClient<GCoreEndpoint> client = ICFactory.clientFor(GCoreEndpoint.class);
        List<GCoreEndpoint> resources = client.submit(query);
        if (resources == null || resources.size() == 0) {
            throw new Exception("No WPS resource available in scope " + this.scope);
        }
        ArrayList<String> resourcesNames = new ArrayList<String>();
        System.out.println("Found " + resources.size() + " resources");
        FileWriter fw = new FileWriter(new File(dumpfile));
        for (GCoreEndpoint resource : resources) {
            String uri = ((GCoreEndpoint.Profile.Endpoint)resource.profile().endpoints().iterator().next()).uri().toString();
            URL url = new URL(uri);
            String host = url.getHost();
            System.out.println(host);
            fw.write(String.valueOf(host) + System.lineSeparator());
        }
        fw.close();
        return resourcesNames;
    }

    public List<String> getAlgorithmsInScope() throws Exception {
        System.out.println("Searching for Algorithms in scope " + this.scope);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType eq 'StatisticalManagerAlgorithm' ");
        DiscoveryClient<GenericResource> client = ICFactory.clientFor(GenericResource.class);
        List<GenericResource> resources = client.submit(query);
        if (resources == null || resources.size() == 0) {
            throw new Exception("No resource named StatisticalManagerAlgorithm available in scope " + this.scope);
        }
        ArrayList<String> resourcesNames = new ArrayList<String>();
        System.out.println("Found " + resources.size() + " resources");
        for (GenericResource resource : resources) {
            resourcesNames.add(resource.profile().name());
        }
        return resourcesNames;
    }

    public static void main(String[] args) throws Exception {
        InfrastructureDialoguer dialoguer = new InfrastructureDialoguer(args[0]);
        dialoguer.getWPSGcoreEndpoints(args[1]);
    }
}

