/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.peer.task;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.ProtocolException;
import org.bitlet.wetorrent.Torrent;
import org.bitlet.wetorrent.peer.TorrentPeer;
import org.bitlet.wetorrent.util.thread.ThreadTask;

public class MessageReceiver
implements ThreadTask {
    private TorrentPeer peer;
    private long lastReceivedMessageMillis;
    private long receivedBytes;

    public MessageReceiver(TorrentPeer peer) {
        this.peer = peer;
    }

    private synchronized void addReceivedBytes(Integer byteNumber) {
        this.receivedBytes += (long)byteNumber.intValue();
    }

    public synchronized Long getReceivedBytes() {
        return this.receivedBytes;
    }

    @Override
    public boolean execute() throws Exception {
        try {
            DataInputStream is = new DataInputStream(this.peer.getSocket().getInputStream());
            int prefixLength = is.readInt();
            this.addReceivedBytes(4 + prefixLength);
            if (prefixLength == 0) {
                this.peer.keepAlive();
            } else if (prefixLength > 0) {
                byte messageId = is.readByte();
                switch (messageId) {
                    case 0: {
                        if (prefixLength != 1) {
                            throw new ProtocolException("pl " + prefixLength);
                        }
                        this.peer.choke();
                        break;
                    }
                    case 1: {
                        if (prefixLength != 1) {
                            throw new ProtocolException();
                        }
                        this.peer.unchoke();
                        break;
                    }
                    case 2: {
                        if (prefixLength != 1) {
                            throw new ProtocolException();
                        }
                        this.peer.interested();
                        break;
                    }
                    case 3: {
                        if (prefixLength != 1) {
                            throw new ProtocolException();
                        }
                        this.peer.notInterested();
                        break;
                    }
                    case 4: {
                        if (prefixLength != 5) {
                            throw new ProtocolException();
                        }
                        this.peer.have(is.readInt());
                        break;
                    }
                    case 5: {
                        if (prefixLength != 1 + this.peer.getBitfieldCopy().length) {
                            throw new ProtocolException();
                        }
                        byte[] bitField = new byte[prefixLength - 1];
                        is.readFully(bitField);
                        this.peer.bitfield(bitField);
                        break;
                    }
                    case 6: {
                        if (prefixLength != 13) {
                            throw new ProtocolException();
                        }
                        this.peer.request(is.readInt(), is.readInt(), is.readInt());
                        break;
                    }
                    case 7: {
                        if (prefixLength < 10) {
                            throw new ProtocolException();
                        }
                        int index = is.readInt();
                        int begin = is.readInt();
                        byte[] block = new byte[prefixLength - 9];
                        is.readFully(block);
                        this.peer.piece(index, begin, block);
                        break;
                    }
                    case 8: {
                        if (prefixLength != 13) {
                            throw new ProtocolException();
                        }
                        this.peer.cancel(is.readInt(), is.readInt(), is.readInt());
                        break;
                    }
                    default: {
                        int skipped = 0;
                        while ((skipped = is.skipBytes(prefixLength - 1 - skipped)) == prefixLength - 1) {
                        }
                        break;
                    }
                }
            } else {
                throw new Exception("Negative prefix length");
            }
            this.setLastReceivedMessageMillis(System.currentTimeMillis());
        }
        catch (Exception e) {
            if (Torrent.SHOW_EXCEPTIONS) {
                e.printStackTrace(System.err);
            }
            throw e;
        }
        return true;
    }

    @Override
    public void interrupt() {
        try {
            this.peer.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void exceptionCought(Exception e) {
        this.peer.interrupt();
    }

    public synchronized long getLastReceivedMessageMillis() {
        return this.lastReceivedMessageMillis;
    }

    public synchronized void setLastReceivedMessageMillis(long lastReceivedMessageMillis) {
        this.lastReceivedMessageMillis = lastReceivedMessageMillis;
    }
}

