/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.peer;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bitlet.wetorrent.Torrent;
import org.bitlet.wetorrent.peer.TorrentPeer;
import org.bitlet.wetorrent.util.thread.InterruptableTasksThread;
import org.bitlet.wetorrent.util.thread.ThreadTask;

public class IncomingPeerListener
extends InterruptableTasksThread {
    ServerSocket serverSocket;
    private Map<ByteBuffer, Torrent> torrents = new HashMap<ByteBuffer, Torrent>();
    private Set<TorrentPeer> dispatchingPeers = new HashSet<TorrentPeer>();
    private int port;
    private int receivedConnection = 0;

    public IncomingPeerListener(int port) {
        while (port < 65535 && this.serverSocket == null) {
            try {
                this.serverSocket = new ServerSocket(port);
            }
            catch (Exception e) {
                ++port;
            }
        }
        if (this.serverSocket == null) {
            System.err.println("Cannot bind the incoming socket");
            return;
        }
        this.port = port;
        final IncomingPeerListener incomingPeerListener = this;
        this.addTask(new ThreadTask(){

            @Override
            public boolean execute() throws Exception {
                try {
                    Socket socket = IncomingPeerListener.this.serverSocket.accept();
                    IncomingPeerListener.this.receivedConnection++;
                    TorrentPeer peer = new TorrentPeer(socket, incomingPeerListener);
                    IncomingPeerListener.this.dispatchingPeers.add(peer);
                    peer.start();
                }
                catch (SocketException e) {
                    return false;
                }
                return true;
            }

            @Override
            public void interrupt() {
                try {
                    IncomingPeerListener.this.serverSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void exceptionCought(Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public int getPort() {
        return this.port;
    }

    public int getReceivedConnection() {
        return this.receivedConnection;
    }

    public synchronized void register(Torrent torrent) {
        this.torrents.put(ByteBuffer.wrap(torrent.getMetafile().getInfoSha1()), torrent);
    }

    public synchronized void unregister(Torrent torrent) {
        this.torrents.remove(ByteBuffer.wrap(torrent.getMetafile().getInfoSha1()));
    }

    public synchronized void peer(TorrentPeer dispatchingPeer) {
        this.dispatchingPeers.add(dispatchingPeer);
    }

    public synchronized boolean dispatchPeer(TorrentPeer dispatchingPeer, byte[] infoSha1) {
        this.dispatchingPeers.remove(dispatchingPeer);
        Torrent torrent = this.torrents.get(ByteBuffer.wrap(infoSha1));
        if (torrent != null) {
            dispatchingPeer.setPeersManager(torrent.getPeersManager());
            torrent.getPeersManager().offer(dispatchingPeer);
            return true;
        }
        return false;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        for (TorrentPeer p : this.dispatchingPeers) {
            p.interrupt();
        }
    }

    public synchronized void removePeer(TorrentPeer peer) {
        this.dispatchingPeers.remove(peer);
    }
}

