/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.bencode;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Comparator;

public class DictionaryComparator
implements Comparator<ByteBuffer>,
Serializable {
    private static final long serialVersionUID = -5445072464551888217L;

    public int bitCompare(byte b1, byte b2) {
        int int1 = b1 & 0xFF;
        int int2 = b2 & 0xFF;
        return int1 - int2;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        byte[] byteString2;
        byte[] byteString1 = o1.array();
        int minLength = byteString1.length > (byteString2 = o2.array()).length ? byteString2.length : byteString1.length;
        for (int i = 0; i < minLength; ++i) {
            int bitCompare = this.bitCompare(byteString1[i], byteString2[i]);
            if (bitCompare == 0) continue;
            return bitCompare;
        }
        if (byteString1.length > byteString2.length) {
            return 1;
        }
        if (byteString1.length < byteString2.length) {
            return -1;
        }
        return 0;
    }
}

