/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.util.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.bitlet.wetorrent.util.stream.BandwidthLimiter;

public class OutputStreamLimiter
extends OutputStream {
    private OutputStream os;
    private BandwidthLimiter bandwidthLimiter;

    public OutputStreamLimiter(OutputStream os, BandwidthLimiter bandwidthLimiter) {
        this.os = os;
        this.bandwidthLimiter = bandwidthLimiter;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bandwidthLimiter != null) {
            this.bandwidthLimiter.limitNextBytes(1);
        }
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bandwidthLimiter != null) {
            this.bandwidthLimiter.limitNextBytes(len);
        }
        this.os.write(b, off, len);
    }
}

